/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.maxrepel.item;

import com.github.slaxlax.maxrepel.ConfigLoader;
import com.github.slaxlax.maxrepel.MaxRepelConfig;
import com.github.slaxlax.maxrepel.blockentities.SprayerBlockEntity;
import com.github.slaxlax.maxrepel.registry.BlocksRegistry;
import com.github.slaxlax.maxrepel.registry.EffectsRegistry;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u001f2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b \u0010!J'\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\"\u0010#J5\u0010+\u001a\u00020*2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b+\u0010,R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010-R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010.\u001a\u0004\b/\u00100R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u00101R\u001c\u00104\u001a\n 3*\u0004\u0018\u000102028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00066"}, d2={"Lcom/github/slaxlax/maxrepel/item/RepelConsumable;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/effect/MobEffect;", "effect", "", "duration", "", "tooltipKey", "<init>", "(Lnet/minecraft/core/Holder;ILjava/lang/String;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lnet/minecraft/world/item/UseAnim;", "getUseAnimation", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;", "Lnet/minecraft/world/entity/LivingEntity;", "entity", "getUseDuration", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)I", "Lnet/minecraft/world/item/context/UseOnContext;", "context", "Lnet/minecraft/world/InteractionResult;", "useOn", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/level/Level;", "world", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResultHolder;", "use", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;", "finishUsingItem", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/world/item/Item$TooltipContext;", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "Lnet/minecraft/world/item/TooltipFlag;", "flag", "", "appendHoverText", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/Item$TooltipContext;Ljava/util/List;Lnet/minecraft/world/item/TooltipFlag;)V", "Lnet/minecraft/core/Holder;", "I", "getDuration", "()I", "Ljava/lang/String;", "Lcom/github/slaxlax/maxrepel/MaxRepelConfig;", "kotlin.jvm.PlatformType", "config", "Lcom/github/slaxlax/maxrepel/MaxRepelConfig;", "MaxRepel-neoforge"})
public final class RepelConsumable
extends Item {
    @NotNull
    private final Holder<MobEffect> effect;
    private final int duration;
    @NotNull
    private final String tooltipKey;
    private final MaxRepelConfig config;

    public RepelConsumable(@NotNull Holder<MobEffect> effect, int duration, @NotNull String tooltipKey) {
        Intrinsics.checkNotNullParameter(effect, (String)"effect");
        Intrinsics.checkNotNullParameter((Object)tooltipKey, (String)"tooltipKey");
        super(new Item.Properties().stacksTo(16));
        this.effect = effect;
        this.duration = duration;
        this.tooltipKey = tooltipKey;
        this.config = ConfigLoader.loadConfig();
    }

    public final int getDuration() {
        return this.duration;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return UseAnim.DRINK;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return 32;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        BlockEntity be;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        ItemStack stack = context.getItemInHand();
        BlockState state = world.getBlockState(pos);
        if (!world.isClientSide && state.is((Holder)BlocksRegistry.INSTANCE.getREPEL_SPRAYER()) && (be = world.getBlockEntity(pos)) instanceof SprayerBlockEntity) {
            int currentTime = ((SprayerBlockEntity)be).getRepelTime();
            int toAdd = this.duration;
            if (currentTime >= this.config.MaxSprayerDuration) {
                player2.displayClientMessage((Component)Component.literal((String)"This Repel Sprayer has reached its maximum capacity."), true);
                return InteractionResult.FAIL;
            }
            int clampedAddition = RangesKt.coerceAtMost((int)(currentTime + toAdd), (int)this.config.MaxSprayerDuration) - currentTime;
            if (clampedAddition > 0) {
                stack.shrink(1);
                ((SprayerBlockEntity)be).addRepelTime(clampedAddition);
                ((SprayerBlockEntity)be).setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
                int percentage = RangesKt.coerceAtMost((int)(currentTime + toAdd), (int)this.config.MaxSprayerDuration) * 100 / this.config.MaxSprayerDuration;
                player2.displayClientMessage((Component)Component.literal((String)("Repel refilled - " + percentage + "%")), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.consume((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"consume(...)");
        return interactionResultHolder;
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level world, @NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof Player && !world.isClientSide) {
            LivingEntity player = entity;
            DeferredHolder[] deferredHolderArray = new DeferredHolder[]{EffectsRegistry.INSTANCE.getREPEL(), EffectsRegistry.INSTANCE.getSUPER_REPEL(), EffectsRegistry.INSTANCE.getMAX_REPEL()};
            List repelEffects = CollectionsKt.listOf((Object[])deferredHolderArray);
            for (DeferredHolder effect : repelEffects) {
                if (!player.hasEffect((Holder)effect)) continue;
                player.removeEffect((Holder)effect);
            }
            entity.addEffect(new MobEffectInstance(this.effect, this.duration * 20));
        }
        if (entity instanceof Player && !((Player)entity).isCreative()) {
            stack.shrink(1);
        }
        return stack;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        MutableComponent mutableComponent = Component.translatable((String)this.tooltipKey);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        tooltip.add((Component)mutableComponent);
    }
}

