/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.maxrepel.blockentities;

import com.github.slaxlax.maxrepel.block.SprayerBlock;
import com.github.slaxlax.maxrepel.blockentities.SprayerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J?\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/github/slaxlax/maxrepel/blockentities/SprayerBlockEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcom/github/slaxlax/maxrepel/blockentities/SprayerBlockEntity;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "sprayer", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "poseStack", "Lnet/minecraft/client/renderer/MultiBufferSource;", "bufferSource", "", "combinedLight", "combinedOverlay", "", "render", "(Lcom/github/slaxlax/maxrepel/blockentities/SprayerBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "MaxRepel-neoforge"})
public final class SprayerBlockEntityRenderer
implements BlockEntityRenderer<SprayerBlockEntity> {
    public SprayerBlockEntityRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public void render(@NotNull SprayerBlockEntity sprayer, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)sprayer), (String)"sprayer");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        BlockState blockState = sprayer.getBlockState();
        if (!((Boolean)blockState.getValue((Property)SprayerBlock.Companion.getACTIVE())).booleanValue()) {
            return;
        }
        BlockState modelState = (BlockState)sprayer.getBlockState().setValue((Property)SprayerBlock.Companion.getACTIVE(), (Comparable)Boolean.valueOf(false));
        BakedModel bakedModel = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(modelState);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        if (((Boolean)blockState.getValue((Property)SprayerBlock.Companion.getACTIVE())).booleanValue()) {
            Level level = sprayer.getLevel();
            float rotation = ((float)(level != null ? level.getGameTime() : 0L) + partialTicks) * 4.0f % 360.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.cutout());
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(pose, vertexConsumer, blockState, bakedModel, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, ModelData.EMPTY, RenderType.cutout());
        poseStack.popPose();
    }
}

