/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.maxrepel.blockentities;

import com.github.slaxlax.maxrepel.MaxRepel;
import com.github.slaxlax.maxrepel.block.SprayerBlock;
import com.github.slaxlax.maxrepel.registry.BlockEntitiesRegistry;
import com.github.slaxlax.maxrepel.registry.POIRegistry;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\fJ\r\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\n\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b'\u0010&J\u000f\u0010(\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b(\u0010&R\u0016\u0010)\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/github/slaxlax/maxrepel/blockentities/SprayerBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "", "ticks", "", "addRepelTime", "(I)V", "amount", "decrementRepelTime", "getRepelTime", "()I", "Lnet/minecraft/nbt/CompoundTag;", "tag", "Lnet/minecraft/core/HolderLookup$Provider;", "provider", "saveAdditional", "(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V", "loadAdditional", "lookupProvider", "getUpdateTag", "(Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/nbt/CompoundTag;", "Lnet/minecraft/network/Connection;", "net", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "pkt", "onDataPacket", "(Lnet/minecraft/network/Connection;Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;Lnet/minecraft/core/HolderLookup$Provider;)V", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getUpdatePacket", "()Lnet/minecraft/network/protocol/Packet;", "clientTick", "()V", "registerPoi", "unregisterPoi", "repelTime", "I", "MaxRepel-neoforge"})
@SourceDebugExtension(value={"SMAP\nSprayerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SprayerBlockEntity.kt\ncom/github/slaxlax/maxrepel/blockentities/SprayerBlockEntity\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,144:1\n13805#2,2:145\n*S KotlinDebug\n*F\n+ 1 SprayerBlockEntity.kt\ncom/github/slaxlax/maxrepel/blockentities/SprayerBlockEntity\n*L\n114#1:145,2\n*E\n"})
public final class SprayerBlockEntity
extends BlockEntity {
    private int repelTime;

    public SprayerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super((BlockEntityType)BlockEntitiesRegistry.INSTANCE.getREPEL_SPRAYER().get(), pos, state);
    }

    public final void addRepelTime(int ticks) {
        this.repelTime += ticks;
        if (this.repelTime > 0) {
            BlockState currentState;
            this.registerPoi();
            Level level = this.level;
            BlockState blockState = currentState = level != null ? level.getBlockState(this.getBlockPos()) : null;
            if (currentState != null && currentState.hasProperty((Property)SprayerBlock.Companion.getACTIVE()) && !((Boolean)currentState.getValue((Property)SprayerBlock.Companion.getACTIVE())).booleanValue()) {
                Level level2 = this.level;
                if (level2 != null) {
                    level2.setBlock(this.getBlockPos(), (BlockState)currentState.setValue((Property)SprayerBlock.Companion.getACTIVE(), (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
        this.setChanged();
    }

    public final void decrementRepelTime(int amount) {
        if (this.repelTime > 0) {
            this.repelTime = RangesKt.coerceAtLeast((int)(this.repelTime - amount), (int)0);
            if (this.repelTime == 0) {
                BlockState currentState;
                this.unregisterPoi();
                Level level = this.level;
                BlockState blockState = currentState = level != null ? level.getBlockState(this.getBlockPos()) : null;
                if (currentState != null && currentState.hasProperty((Property)SprayerBlock.Companion.getACTIVE()) && ((Boolean)currentState.getValue((Property)SprayerBlock.Companion.getACTIVE())).booleanValue()) {
                    Level level2 = this.level;
                    if (level2 != null) {
                        level2.setBlock(this.getBlockPos(), (BlockState)currentState.setValue((Property)SprayerBlock.Companion.getACTIVE(), (Comparable)Boolean.valueOf(false)), 3);
                    }
                }
            }
            this.setChanged();
        }
    }

    public final int getRepelTime() {
        return this.repelTime;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.saveAdditional(tag, provider);
        tag.putInt("RepelTime", this.repelTime);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super.loadAdditional(tag, provider);
        this.repelTime = tag.getInt("RepelTime");
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, lookupProvider);
        return tag;
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, @NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)net, (String)"net");
        Intrinsics.checkNotNullParameter((Object)pkt, (String)"pkt");
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.loadAdditional(tag, lookupProvider);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this, BlockEntity::getUpdateTag);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    public final void clientTick() {
        Pair[] basePositions;
        if (!((Boolean)this.getBlockState().getValue((Property)SprayerBlock.Companion.getACTIVE())).booleanValue()) {
            return;
        }
        double x = (double)this.getBlockPos().getX() + 0.5;
        double y = (double)this.getBlockPos().getY() + 0.4;
        double z = (double)this.getBlockPos().getZ() + 0.5;
        double radius = 0.7;
        double speed = 0.04;
        Level level = this.level;
        float rotationDegrees = (float)(level != null ? level.getGameTime() : 0L) * 4.0f % 360.0f;
        double rotationRad = Math.toRadians(rotationDegrees);
        float r = 0.36078432f;
        float g = 0.5803922f;
        float b = 0.26666668f;
        DustParticleOptions colorParticle = new DustParticleOptions(new Vector3f(r, g, b), 1.0f);
        Pair[] pairArray = new Pair[]{new Pair((Object)radius, (Object)0.0), new Pair((Object)(-radius), (Object)0.0), new Pair((Object)0.0, (Object)radius), new Pair((Object)0.0, (Object)(-radius))};
        Pair[] $this$forEach$iv = basePositions = pairArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair element$iv;
            Pair pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            double dx = ((Number)pair.component1()).doubleValue();
            double dz = ((Number)pair.component2()).doubleValue();
            double rotatedX = Math.cos(rotationRad) * dx + Math.sin(rotationRad) * dz;
            double rotatedZ = -Math.sin(rotationRad) * dx + Math.cos(rotationRad) * dz;
            Level level2 = this.level;
            if (level2 == null) continue;
            level2.addParticle((ParticleOptions)colorParticle, x + rotatedX, y, z + rotatedZ, rotatedX * speed, 0.0, rotatedZ * speed);
        }
    }

    private final void registerPoi() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        serverLevel2.getPoiManager().add(this.getBlockPos(), (Holder)POIRegistry.INSTANCE.getSPRAYER_POI());
        MaxRepel.Companion.getLOGGER().info("[SPRAYER] Registering sprayer.");
    }

    private final void unregisterPoi() {
        Level level = this.level;
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        serverLevel2.getPoiManager().remove(this.getBlockPos());
        MaxRepel.Companion.getLOGGER().info("[SPRAYER] Removing sprayer.");
    }
}

