/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.maxrepel.block;

import com.github.slaxlax.maxrepel.blockentities.CreativeSprayerBlockEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\u000b\u001a\u00020\n2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007H\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0015H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u0019JA\u0010!\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 \"\n\b\u0000\u0010\u001b*\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016\u00a2\u0006\u0004\b!\u0010\"J7\u0010(\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0014\u00a2\u0006\u0004\b(\u0010)J7\u0010-\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010*\u001a\u00020\b2\u0006\u0010,\u001a\u00020+H\u0014\u00a2\u0006\u0004\b-\u0010.J7\u00100\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010/\u001a\u00020\b2\u0006\u0010,\u001a\u00020+H\u0014\u00a2\u0006\u0004\b0\u0010.J/\u00101\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b1\u00102\u00a8\u00064"}, d2={"Lcom/github/slaxlax/maxrepel/block/CreativeSprayerBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/EntityBlock;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "properties", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "createBlockStateDefinition", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "Lnet/minecraft/core/BlockPos;", "pos", "state", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "newBlockEntity", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/level/BlockGetter;", "world", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "context", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getShape", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "getCollisionShape", "T", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "getTicker", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/BlockEntityType;)Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/phys/BlockHitResult;", "hit", "Lnet/minecraft/world/InteractionResult;", "useWithoutItem", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;", "oldState", "", "isMoving", "onPlace", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V", "newState", "onRemove", "spawnDestroyParticles", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "MaxRepel-neoforge"})
public final class CreativeSprayerBlock
extends Block
implements EntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BooleanProperty ACTIVE;
    @NotNull
    private static final VoxelShape HALF_STEP_SHAPE;

    public CreativeSprayerBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{ACTIVE};
        builder.add(propertyArray);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new CreativeSprayerBlockEntity(pos, state);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return HALF_STEP_SHAPE;
    }

    @NotNull
    protected VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return HALF_STEP_SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return level.isClientSide ? CreativeSprayerBlock::getTicker$lambda$0 : null;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        if (!player.isCreative() || !player.getMainHandItem().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockState newState = (BlockState)state.cycle((Property)ACTIVE);
        level.setBlock(pos, newState, 3);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CreativeSprayerBlockEntity) {
            CreativeSprayerBlockEntity creativeSprayerBlockEntity = (CreativeSprayerBlockEntity)blockEntity;
            Comparable comparable = newState.getValue((Property)ACTIVE);
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
            creativeSprayerBlockEntity.handleActiveStateChange((Boolean)comparable);
        }
        return InteractionResult.CONSUME;
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        BlockEntity be;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        super.onPlace(state, world, pos, oldState, isMoving);
        if (!world.isClientSide && (be = world.getBlockEntity(pos)) instanceof CreativeSprayerBlockEntity && ((Boolean)state.getValue((Property)ACTIVE)).booleanValue()) {
            ((CreativeSprayerBlockEntity)be).handleActiveStateChange(true);
        }
    }

    protected void onRemove(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity be;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (!world.isClientSide && !Intrinsics.areEqual((Object)state.getBlock(), (Object)newState.getBlock()) && (be = world.getBlockEntity(pos)) instanceof CreativeSprayerBlockEntity) {
            ((CreativeSprayerBlockEntity)be).handleActiveStateChange(false);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    protected void spawnDestroyParticles(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!level.isClientSide) {
            return;
        }
        RandomSource random = level.random;
        BlockState inactiveState = (BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        for (int i = 0; i < 10; ++i) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, inactiveState), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static final void getTicker$lambda$0(Level lvl, BlockPos pos, BlockState st, BlockEntity be) {
        Intrinsics.checkNotNullParameter((Object)lvl, (String)"lvl");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)st, (String)"st");
        if (be instanceof CreativeSprayerBlockEntity) {
            ((CreativeSprayerBlockEntity)be).clientTick();
        }
    }

    static {
        BooleanProperty booleanProperty = BooleanProperty.create((String)"active");
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"create(...)");
        ACTIVE = booleanProperty;
        VoxelShape voxelShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        HALF_STEP_SHAPE = voxelShape;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/github/slaxlax/maxrepel/block/CreativeSprayerBlock$Companion;", "", "<init>", "()V", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "ACTIVE", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getACTIVE", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "HALF_STEP_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getHALF_STEP_SHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "MaxRepel-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BooleanProperty getACTIVE() {
            return ACTIVE;
        }

        @NotNull
        public final VoxelShape getHALF_STEP_SHAPE() {
            return HALF_STEP_SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

