/*
 * Decompiled with CFR 0.152.
 */
package com.github.slaxlax.maxrepel;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.cooking.PokeSnackSpawnPokemonEvent;
import com.cobblemon.mod.common.api.events.entity.SpawnEvent;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.block.entity.PokeSnackBlockEntity;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.slaxlax.maxrepel.ConfigLoader;
import com.github.slaxlax.maxrepel.MaxRepelConfig;
import com.github.slaxlax.maxrepel.registry.EffectsRegistry;
import com.github.slaxlax.maxrepel.registry.POIRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0019\u0010\b\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/github/slaxlax/maxrepel/RepelListener;", "", "<init>", "()V", "", "register", "Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;", "event", "onPokemonSpawn", "(Lcom/cobblemon/mod/common/api/events/entity/SpawnEvent;)V", "Lcom/cobblemon/mod/common/api/events/cooking/PokeSnackSpawnPokemonEvent$Pre;", "onSnackSpawn", "(Lcom/cobblemon/mod/common/api/events/cooking/PokeSnackSpawnPokemonEvent$Pre;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "hasRepelEffect", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lcom/github/slaxlax/maxrepel/MaxRepelConfig;", "kotlin.jvm.PlatformType", "config", "Lcom/github/slaxlax/maxrepel/MaxRepelConfig;", "MaxRepel-neoforge"})
@SourceDebugExtension(value={"SMAP\nRepelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepelListener.kt\ncom/github/slaxlax/maxrepel/RepelListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n295#2,2:137\n*S KotlinDebug\n*F\n+ 1 RepelListener.kt\ncom/github/slaxlax/maxrepel/RepelListener\n*L\n76#1:137,2\n*E\n"})
public final class RepelListener {
    @NotNull
    public static final RepelListener INSTANCE = new RepelListener();
    private static final MaxRepelConfig config = ConfigLoader.loadConfig();

    private RepelListener() {
    }

    public final void register() {
        CobblemonEvents.POKEMON_ENTITY_SPAWN.subscribe(Priority.HIGH, new Function1<SpawnEvent<?>, Unit>(this){

            public final void invoke(SpawnEvent<?> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((RepelListener)this.receiver).onPokemonSpawn(p0);
            }
        });
        CobblemonEvents.POKE_SNACK_SPAWN_POKEMON_PRE.subscribe(Priority.HIGH, (Function1)new Function1<PokeSnackSpawnPokemonEvent.Pre, Unit>((Object)this){

            public final void invoke(PokeSnackSpawnPokemonEvent.Pre p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((RepelListener)this.receiver).onSnackSpawn(p0);
            }
        });
    }

    public final void onPokemonSpawn(@NotNull SpawnEvent<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Entity entity = event.getEntity();
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        Pokemon pokemon = ((PokemonEntity)entity).getPokemon();
        if (RepelListener.config.ExcludedPokemon.contains(pokemon.getSpecies().getResourceIdentifier().toString())) {
            return;
        }
        if (RepelListener.config.ExcludeShiny && pokemon.getShiny()) {
            return;
        }
        Level level = ((PokemonEntity)entity).level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Level level2 = level;
        ServerLevel serverLevel = level2 instanceof ServerLevel ? (ServerLevel)level2 : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        BlockPos blockPos = entity.blockPosition();
        DeferredHolder<PoiType, PoiType> sprayerPOIHolder = POIRegistry.INSTANCE.getSPRAYER_POI();
        Optional nearbySprayers = serverLevel2.getPoiManager().find(arg_0 -> RepelListener.onPokemonSpawn$lambda$0(sprayerPOIHolder, arg_0), RepelListener::onPokemonSpawn$lambda$1, blockPos, RepelListener.config.SprayerRadius, PoiManager.Occupancy.ANY);
        Intrinsics.checkNotNull((Object)nearbySprayers);
        if (!((Collection)OptionalsKt.toList((Optional)nearbySprayers)).isEmpty()) {
            event.cancel();
            return;
        }
        double radius = RepelListener.config.MatchCobblemonSpawnRadius ? (double)Cobblemon.INSTANCE.getConfig().getMaximumSpawningZoneDistanceFromPlayer() : (double)RepelListener.config.RepelRadius;
        List nearbyPlayers = level2.getEntitiesOfClass(Player.class, new AABB((double)blockPos.getX() - radius, (double)blockPos.getY() - radius, (double)blockPos.getZ() - radius, (double)blockPos.getX() + radius, (double)blockPos.getY() + radius, (double)blockPos.getZ() + radius));
        for (Player player : nearbyPlayers) {
            Intrinsics.checkNotNull((Object)player);
            if (!RepelListener.hasRepelEffect(player)) continue;
            if (RepelListener.config.OnlyRepelLowerLvl) {
                Pokemon firstNonFainted;
                Object v2;
                block8: {
                    PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty((ServerPlayer)player);
                    Iterable $this$firstOrNull$iv = (Iterable)party;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pokemon it = (Pokemon)element$iv;
                        boolean bl = false;
                        if (!(!it.isFainted())) continue;
                        v2 = element$iv;
                        break block8;
                    }
                    v2 = null;
                }
                if ((firstNonFainted = (Pokemon)v2) == null || ((PokemonEntity)entity).getPokemon().getLevel() >= firstNonFainted.getLevel()) continue;
                event.cancel();
                return;
            }
            event.cancel();
            return;
        }
    }

    public final void onSnackSpawn(@NotNull PokeSnackSpawnPokemonEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PokeSnackBlockEntity snack = event.getPokeSnackBlockEntity();
        BlockPos blockPos = snack.getBlockPos();
        Level level = snack.getLevel();
        ServerLevel serverLevel = level instanceof ServerLevel ? (ServerLevel)level : null;
        if (serverLevel == null) {
            return;
        }
        ServerLevel serverLevel2 = serverLevel;
        DeferredHolder<PoiType, PoiType> sprayerPOIHolder = POIRegistry.INSTANCE.getSPRAYER_POI();
        Optional nearbySprayers = serverLevel2.getPoiManager().find(arg_0 -> RepelListener.onSnackSpawn$lambda$0(sprayerPOIHolder, arg_0), RepelListener::onSnackSpawn$lambda$1, blockPos, RepelListener.config.SprayerRadius, PoiManager.Occupancy.ANY);
        Intrinsics.checkNotNull((Object)nearbySprayers);
        if (!((Collection)OptionalsKt.toList((Optional)nearbySprayers)).isEmpty()) {
            event.cancel();
            return;
        }
        double radius = RepelListener.config.MatchCobblemonSpawnRadius ? (double)Cobblemon.INSTANCE.getConfig().getMaximumSpawningZoneDistanceFromPlayer() : (double)RepelListener.config.RepelRadius;
        List nearbyPlayers = serverLevel2.getEntitiesOfClass(Player.class, new AABB((double)blockPos.getX() - radius, (double)blockPos.getY() - radius, (double)blockPos.getZ() - radius, (double)blockPos.getX() + radius, (double)blockPos.getY() + radius, (double)blockPos.getZ() + radius));
        for (Player player : nearbyPlayers) {
            Intrinsics.checkNotNull((Object)player);
            if (!RepelListener.hasRepelEffect(player)) continue;
            event.cancel();
            return;
        }
    }

    @JvmStatic
    public static final boolean hasRepelEffect(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return player.hasEffect((Holder)EffectsRegistry.INSTANCE.getREPEL()) || player.hasEffect((Holder)EffectsRegistry.INSTANCE.getSUPER_REPEL()) || player.hasEffect((Holder)EffectsRegistry.INSTANCE.getMAX_REPEL());
    }

    private static final boolean onPokemonSpawn$lambda$0(DeferredHolder $sprayerPOIHolder, Holder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return Intrinsics.areEqual((Object)holder, (Object)$sprayerPOIHolder);
    }

    private static final boolean onPokemonSpawn$lambda$1(BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    private static final boolean onSnackSpawn$lambda$0(DeferredHolder $sprayerPOIHolder, Holder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return Intrinsics.areEqual((Object)holder, (Object)$sprayerPOIHolder);
    }

    private static final boolean onSnackSpawn$lambda$1(BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }
}

