/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.feature.configuration.RuTreeConfiguration;

public class BambooTreeFeature
extends Feature<RuTreeConfiguration> {
    public BambooTreeFeature(Codec<RuTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<RuTreeConfiguration> context) {
        RuTreeConfiguration treeConfiguration = (RuTreeConfiguration)context.config();
        BlockPos pos = context.origin();
        RandomSource randomSource = context.random();
        WorldGenLevel level = context.level();
        int height_main = context.random().nextInt(treeConfiguration.sizeVariation) + treeConfiguration.minimumSize;
        BlockPos.MutableBlockPos checkPos = pos.mutable();
        for (int check = 0; check <= height_main; ++check) {
            if (!this.checkReplaceable((LevelAccessor)level, (BlockPos)checkPos)) {
                return false;
            }
            checkPos.move(Direction.UP);
        }
        BlockPos.MutableBlockPos placePos = pos.mutable();
        for (int placeCheck = 0; placeCheck <= height_main; ++placeCheck) {
            this.placeLog((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            if (placeCheck == height_main) {
                this.placeLeavesBlob((LevelAccessor)level, (BlockPos)placePos, randomSource, treeConfiguration);
            }
            placePos.move(Direction.UP);
        }
        return true;
    }

    public void placeLog(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return;
        }
        if (level.getBlockState(pos).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.PEAT_PODZOL.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos, RuBlocks.SILT_PODZOL.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos, Blocks.PODZOL.defaultBlockState(), 2);
        } else if (level.getBlockState(pos).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos, Blocks.PODZOL.defaultBlockState(), 2);
        } else if (BambooTreeFeature.isReplaceable((LevelSimulatedReader)level, pos)) {
            level.setBlock(pos, treeConfiguration.trunkProvider.getState(randomSource, pos), 2);
        }
        if (level.getBlockState(pos.below()).is(RuBlocks.PEAT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.PEAT_PODZOL.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.SILT_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), RuBlocks.SILT_PODZOL.get().defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(RuBlocks.ALPHA_GRASS_BLOCK.get())) {
            level.setBlock(pos.below(), Blocks.PODZOL.defaultBlockState(), 2);
        } else if (level.getBlockState(pos.below()).is(Blocks.GRASS_BLOCK)) {
            level.setBlock(pos.below(), Blocks.PODZOL.defaultBlockState(), 2);
        }
    }

    public void placeLeavesBlob(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        BlockPos.MutableBlockPos pos1 = pos.below(3).mutable();
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.north().east(), randomSource, treeConfiguration);
        }
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.north().west(), randomSource, treeConfiguration);
        }
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.south().east(), randomSource, treeConfiguration);
        }
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.south().west(), randomSource, treeConfiguration);
        }
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south().west(), randomSource, treeConfiguration);
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(2).east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(2).west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(2).east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(2).west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(2).north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(2).south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(2), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(2).north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(2).south(), randomSource, treeConfiguration);
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north().west(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south().east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south().west(), randomSource, treeConfiguration);
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.north().east(), randomSource, treeConfiguration);
        }
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.north().west(), randomSource, treeConfiguration);
        }
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.south().east(), randomSource, treeConfiguration);
        }
        if (randomSource.nextInt(3) == 0) {
            this.placeLeavesBlock(level, pos1.south().west(), randomSource, treeConfiguration);
        }
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.north(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.south(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.east(), randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.west(), randomSource, treeConfiguration);
        pos1.move(Direction.UP);
        this.placeLeavesBlock(level, (BlockPos)pos1, randomSource, treeConfiguration);
        this.placeLeavesBlock(level, pos1.above(), randomSource, treeConfiguration);
    }

    public boolean placeLeavesBlock(LevelAccessor level, BlockPos pos, RandomSource randomSource, RuTreeConfiguration treeConfiguration) {
        Random random = new Random();
        if (level.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (level.getBlockState(pos).canBeReplaced()) {
            level.setBlock(pos, (BlockState)treeConfiguration.foliageProvider.getState(randomSource, pos).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(1)), 2);
        }
        return true;
    }

    public boolean checkReplaceable(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        return BambooTreeFeature.isReplaceable((LevelSimulatedReader)level, pos);
    }

    public static boolean isReplaceableDirtBlock(BlockState state) {
        return state.is(RuTags.TREE_GRASS_REPLACEABLES);
    }

    public static boolean isReplaceableDirt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, BambooTreeFeature::isReplaceableDirtBlock);
    }

    public static boolean isReplaceableBlock(BlockState state) {
        return state.is(RuTags.REPLACEABLE_BLOCKS);
    }

    public static boolean isReplaceable(LevelSimulatedReader reader, BlockPos pos) {
        return reader.isStateAtPosition(pos, BambooTreeFeature::isReplaceableBlock);
    }
}

