/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.grass;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.data.tags.RuTags;
import net.regions_unexplored.world.level.block.plant.tall.RuSandyDoublePlantBlock;
import net.regions_unexplored.world.level.block.state.properties.RuBlockStateProperties;

public class RuSandyPlantBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<? extends RuSandyPlantBlock> CODEC = RuSandyPlantBlock.simpleCodec(RuSandyPlantBlock::new);
    public static final BooleanProperty IS_RED = RuBlockStateProperties.IS_RED;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public RuSandyPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IS_RED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state1, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        if (level.getBlockState(pos.below()).is(Blocks.RED_SAND) || level.getBlockState(pos.below()).is(Blocks.RED_SANDSTONE) || level.getBlockState(pos.below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_sandstone"))) || level.getBlockState(pos.below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sandstone/red"))) || level.getBlockState(pos.below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_sand"))) || level.getBlockState(pos.below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sand/red")))) {
            state.setValue((Property)IS_RED, (Comparable)Boolean.valueOf(true));
        } else {
            state.setValue((Property)IS_RED, (Comparable)Boolean.valueOf(false));
        }
        return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, state1, level, pos, pos2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{IS_RED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean isRed = context.getLevel().getBlockState(context.getClickedPos().below()).is(Blocks.RED_SAND) || context.getLevel().getBlockState(context.getClickedPos().below()).is(Blocks.RED_SANDSTONE) || context.getLevel().getBlockState(context.getClickedPos().below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_sandstone"))) || context.getLevel().getBlockState(context.getClickedPos().below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sandstone/red"))) || context.getLevel().getBlockState(context.getClickedPos().below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"red_sand"))) || context.getLevel().getBlockState(context.getClickedPos().below()).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sand/red")));
        return (BlockState)this.defaultBlockState().setValue((Property)IS_RED, (Comparable)Boolean.valueOf(isRed));
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public static void placeAt(LevelAccessor level, BlockState state, BlockPos pos, int i) {
        level.setBlock(pos, DoublePlantBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)pos, (BlockState)state), i);
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.is(RuTags.SANDY_PLANT_CAN_SURVIVE_ON);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        DoublePlantBlock sandyTallGrass;
        Block sandyTallGrassBlock;
        boolean isRed = (Boolean)state.getValue((Property)IS_RED);
        if (state.is(RuBlocks.SANDY_GRASS.get()) && (sandyTallGrassBlock = RuBlocks.SANDY_TALL_GRASS.get()) instanceof DoublePlantBlock && (sandyTallGrass = (DoublePlantBlock)sandyTallGrassBlock).defaultBlockState().canSurvive((LevelReader)level, pos) && level.isEmptyBlock(pos.above())) {
            RuSandyPlantBlock.placeAt((LevelAccessor)level, (BlockState)sandyTallGrass.defaultBlockState().setValue((Property)IS_RED, (Comparable)Boolean.valueOf(isRed)), pos, 2);
            RuSandyPlantBlock.placeAt((LevelAccessor)level, (BlockState)((BlockState)sandyTallGrass.defaultBlockState().setValue((Property)RuSandyDoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)IS_RED, (Comparable)Boolean.valueOf(isRed)), pos.above(), 2);
        }
    }
}

