/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.grass;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.block.RuBlocks;

public class RuPlantBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<? extends RuPlantBlock> CODEC = RuPlantBlock.simpleCodec(RuPlantBlock::new);
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);
    protected static final VoxelShape SHAPE_MEDIUM_GRASS = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);

    public RuPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (state == RuBlocks.MEDIUM_GRASS.get().defaultBlockState()) {
            return SHAPE_MEDIUM_GRASS;
        }
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public static void placeAt(LevelAccessor level, BlockState state, BlockPos pos, int i) {
        level.setBlock(pos, DoublePlantBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)pos, (BlockState)state), i);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        DoublePlantBlock tallSteppeGrass;
        Block steppe_tall_grass;
        if (state.is(RuBlocks.MEDIUM_GRASS.get())) {
            TallGrassBlock grass = (TallGrassBlock)Blocks.SHORT_GRASS;
            if (grass.defaultBlockState().canSurvive((LevelReader)level, pos)) {
                RuPlantBlock.placeAt((LevelAccessor)level, grass.defaultBlockState(), pos, 2);
            }
        } else if ((state.is(RuBlocks.STEPPE_GRASS.get()) || state.is(RuBlocks.STEPPE_SHRUB.get())) && (steppe_tall_grass = RuBlocks.STEPPE_TALL_GRASS.get()) instanceof DoublePlantBlock && (tallSteppeGrass = (DoublePlantBlock)steppe_tall_grass).defaultBlockState().canSurvive((LevelReader)level, pos) && level.isEmptyBlock(pos.above())) {
            DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)tallSteppeGrass.defaultBlockState(), (BlockPos)pos, (int)2);
        }
    }
}

