/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.branch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.regions_unexplored.data.tags.RuTags;

public class BranchBlock
extends BushBlock {
    public static final MapCodec<? extends BranchBlock> CODEC = BranchBlock.createCodec();
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private final BranchType type;

    private static MapCodec<? extends BranchBlock> createCodec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties), (App)BranchType.CODEC.fieldOf("type").forGetter(BranchBlock::getBranchType)).apply((Applicative)instance, BranchBlock::new));
    }

    public BranchBlock(BlockBehaviour.Properties properties, BranchType type) {
        super(properties);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (Objects.equals((Object)this.type, (Object)BranchType.BEARD)) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                default -> BranchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
                case Direction.NORTH -> BranchBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
                case Direction.EAST -> BranchBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
                case Direction.WEST -> BranchBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> BranchBlock.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0);
            case Direction.NORTH -> BranchBlock.box((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0);
            case Direction.EAST -> BranchBlock.box((double)0.0, (double)4.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0);
            case Direction.WEST -> BranchBlock.box((double)0.0, (double)4.0, (double)6.0, (double)16.0, (double)9.0, (double)10.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = ((Direction)state.getValue((Property)FACING)).getOpposite();
        BlockPos.MutableBlockPos blockPos = pos.mutable().move(direction);
        return this.mayPlaceOn(level.getBlockState((BlockPos)blockPos), (BlockGetter)level, (BlockPos)blockPos);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.is(RuTags.BRANCHES_CAN_SURVIVE_ON);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BranchType getBranchType() {
        return this.type;
    }

    public static enum BranchType implements StringRepresentable
    {
        BRANCH("branch"),
        BEARD("beard");

        public static final Codec<BranchType> CODEC;
        private final String name;

        private BranchType(String type) {
            this.name = type;
        }

        public String getName() {
            return this.name;
        }

        public static BranchType byName(String name) {
            for (BranchType value : BranchType.values()) {
                if (!value.name.equals(name)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown BranchType: " + name);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromValues(BranchType::values);
        }
    }
}

