/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockCompatUtil {
    public static void registerStrippableBlock(Block log, Block strippedLog) {
        AxeItem.STRIPPABLES = Maps.newHashMap((Map)AxeItem.STRIPPABLES);
        AxeItem.STRIPPABLES.put(log, strippedLog);
    }

    public static void registerShovelled(Block block, BlockState shovelledBlock) {
        ShovelItem.FLATTENABLES = Maps.newHashMap((Map)ShovelItem.FLATTENABLES);
        ShovelItem.FLATTENABLES.put(block, shovelledBlock);
    }

    public static void registerCompostableItems(float possibility, ItemLike item) {
        ComposterBlock.COMPOSTABLES.put((Object)item.asItem(), possibility);
    }

    public static void registerFlammableBlock(@Nullable Block block, int spreadSpeed, int flammability) {
        if (block == null) {
            return;
        }
        FireBlock fireblock = (FireBlock)Blocks.FIRE;
        fireblock.setFlammable(block, spreadSpeed, flammability);
    }
}

