/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.platform;

import com.google.auto.service.AutoService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.regions_unexplored.platform.services.IRegistar;

@AutoService(value={IRegistar.class})
public class NeoForgeRegistar
implements IRegistar {
    public static final Map<ResourceKey, DeferredRegister> CACHE = new HashMap<ResourceKey, DeferredRegister>();

    @Override
    public <T> Supplier<T> register(Registry<T> registry, String name, Supplier<T> value) {
        return CACHE.computeIfAbsent(registry.key(), key -> DeferredRegister.create((ResourceLocation)registry.key().location(), (String)"regions_unexplored")).register(name, value);
    }

    @Override
    public Supplier<Block> registerBlock(String name, Supplier<Block> value) {
        return CACHE.computeIfAbsent(BuiltInRegistries.BLOCK.key(), key -> DeferredRegister.create((ResourceLocation)BuiltInRegistries.BLOCK.key().location(), (String)"regions_unexplored")).register(name, value);
    }

    @Override
    public Supplier<Feature> registerFeature(String name, Supplier<Feature> value) {
        return CACHE.computeIfAbsent(BuiltInRegistries.FEATURE.key(), resourceKey -> DeferredRegister.create((Registry)BuiltInRegistries.FEATURE, (String)"regions_unexplored")).register(name, value);
    }

    @Override
    public <T extends Entity> Supplier<EntityType<T>> registerEntity(String path, Supplier<EntityType<T>> type) {
        return CACHE.computeIfAbsent(BuiltInRegistries.ENTITY_TYPE.key(), resourceKey -> DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"regions_unexplored")).register(path, type);
    }

    @Override
    public Supplier<CreativeModeTab> registerCreativeModeTab(String path, Supplier<ItemStack> icon, Supplier<CreativeModeTab.DisplayItemsGenerator> items) {
        return CACHE.computeIfAbsent(BuiltInRegistries.CREATIVE_MODE_TAB.key(), resourceKey -> DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"regions_unexplored")).register(path, () -> CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup.regions_unexplored." + path))).hideTitle().backgroundTexture(ResourceLocation.fromNamespaceAndPath((String)"regions_unexplored", (String)"textures/gui/container/creative_inventory/tab_regions_unexplored_search.png")).withSearchBar(58).icon(icon).displayItems((CreativeModeTab.DisplayItemsGenerator)items.get()).withSearchBar().build());
    }
}

