/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.datagen;

import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;
import net.regions_unexplored.block.RuBlocks;
import net.regions_unexplored.block.set.WoodSet;
import net.regions_unexplored.item.RuItems;
import net.regions_unexplored.world.level.block.plant.food.SalmonBerryBushBlock;

public class RuBlockLootTables
extends BlockLootSubProvider {
    protected static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR));
    private final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.or(this.hasSilkTouch());
    private final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = this.HAS_SHEARS_OR_SILK_TOUCH.invert();
    protected static final float[] ASPEN_LEAVES_SAPLING_CHANCES = new float[]{0.0725f, 0.0785f, 0.0875f, 0.125f};
    protected static final float[] COBALT_LEAVES_SAPLING_CHANCES = new float[]{0.083f, 0.095f, 0.105f, 0.13f};
    protected static final float[] FLOWERING_OAK_LEAVES_SAPLING_CHANCES = new float[]{0.08f, 0.091f, 0.1f, 0.12f};
    protected static final float[] JOSHUA_LEAVES_SAPLING_CHANCES = new float[]{0.13f, 0.15f, 0.17f, 0.185f};
    protected static final float[] PALM_LEAVES_SAPLING_CHANCES = new float[]{0.1f, 0.125f, 0.14f, 0.155f};
    protected static final float[] SMALL_OAK_LEAVES_SAPLING_CHANCES = new float[]{0.075f, 0.08f, 0.089f, 0.1275f};
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    public RuBlockLootTables(HolderLookup.Provider holder) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), holder);
    }

    protected void generate() {
        this.add(RuBlocks.PRISMOSS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(RuBlocks.DEEPSLATE_PRISMOSS.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.dropSelf(RuBlocks.HANGING_PRISMARITE.get());
        this.add(RuBlocks.LARGE_PRISMARITE_CLUSTER.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PRISMAGLASS.get(), x$0 -> this.createSilkTouchOnlyTable((ItemLike)x$0));
        this.dropSelf(RuBlocks.PRISMARITE_CLUSTER.get());
        this.add(RuBlocks.PRISMOSS_SPROUT.get(), RuBlockLootTables::createShearsOnlyDrop);
        this.dropSelf(RuBlocks.POINTED_REDSTONE.get());
        this.dropSelf(RuBlocks.RAW_REDSTONE_BLOCK.get());
        this.add(RuBlocks.REDSTONE_BUD.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
        this.dropSelf(RuBlocks.REDSTONE_BULB.get());
        this.add(RuBlocks.ARGILLITE_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.ARGILLITE.get()));
        this.add(RuBlocks.STONE_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(RuBlocks.DEEPSLATE_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.add(RuBlocks.VIRIDESCENT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLESTONE));
        this.add(RuBlocks.DEEPSLATE_VIRIDESCENT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.COBBLED_DEEPSLATE));
        this.add(RuBlocks.CORPSE_FLOWER.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BLADED_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.BLADED_TALL_GRASS.get(), block -> this.createDoublePlantWithSeedDrops((Block)block, RuBlocks.BLADED_GRASS.get()));
        this.add(RuBlocks.DROPLEAF.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.DROPLEAF_PLANT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.DUSKMELON.get(), block -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.DUSKMELON.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SalmonBerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.DUSKMELON_SLICE.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.DUSKMELON.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SweetBerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.DUSKMELON_SLICE.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE))))));
        this.add(RuBlocks.DUSKTRAP.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.DEAD_STEPPE_SHRUB.get());
        this.add(RuBlocks.ASHEN_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.FROZEN_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.MEDIUM_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.SANDY_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.SMALL_DESERT_SHRUB.get(), RuBlockLootTables::createShearsOnlyDrop);
        this.add(RuBlocks.STEPPE_GRASS.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.STEPPE_SHRUB.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.STONE_BUD.get(), x$0 -> this.createGrassDrops((Block)x$0));
        this.add(RuBlocks.ELEPHANT_EAR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SANDY_TALL_GRASS.get(), block -> this.createDoublePlantWithSeedDrops((Block)block, RuBlocks.SANDY_GRASS.get()));
        this.add(RuBlocks.STEPPE_TALL_GRASS.get(), block -> this.createDoublePlantWithSeedDrops((Block)block, RuBlocks.STEPPE_GRASS.get()));
        this.add(RuBlocks.WINDSWEPT_GRASS.get(), this::createDoublePlantWithSeedDropsNoGrass);
        this.dropSelf(RuBlocks.ALPHA_DANDELION.get());
        this.dropSelf(RuBlocks.ALPHA_ROSE.get());
        this.dropSelf(RuBlocks.ASTER.get());
        this.dropSelf(RuBlocks.BLEEDING_HEART.get());
        this.dropSelf(RuBlocks.BLUE_LUPINE.get());
        this.dropSelf(RuBlocks.DAISY.get());
        this.dropSelf(RuBlocks.DORCEL.get());
        this.dropSelf(RuBlocks.FELICIA_DAISY.get());
        this.dropSelf(RuBlocks.FIREWEED.get());
        this.dropSelf(RuBlocks.HIBISCUS.get());
        this.dropSelf(RuBlocks.HYSSOP.get());
        this.dropSelf(RuBlocks.MALLOW.get());
        this.dropSelf(RuBlocks.PINK_LUPINE.get());
        this.dropSelf(RuBlocks.POPPY_BUSH.get());
        this.dropSelf(RuBlocks.SALMON_POPPY_BUSH.get());
        this.dropSelf(RuBlocks.PURPLE_LUPINE.get());
        this.dropSelf(RuBlocks.RED_LUPINE.get());
        this.dropSelf(RuBlocks.TSUBAKI.get());
        this.dropSelf(RuBlocks.WARATAH.get());
        this.dropSelf(RuBlocks.WHITE_TRILLIUM.get());
        this.dropSelf(RuBlocks.WILTING_TRILLIUM.get());
        this.dropSelf(RuBlocks.YELLOW_LUPINE.get());
        this.add(RuBlocks.ORANGE_CONEFLOWER.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.PURPLE_CONEFLOWER.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.CLOVER.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.BLUE_MAGNOLIA_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.add(RuBlocks.PINK_MAGNOLIA_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.add(RuBlocks.WHITE_MAGNOLIA_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        for (Block block2 : RuBlocks.SNOWBELLES.getAll()) {
            this.dropSelf(block2);
        }
        this.add(RuBlocks.MAPLE_LEAF_PILE.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.RED_MAPLE_LEAF_PILE.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.ORANGE_MAPLE_LEAF_PILE.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.SILVER_BIRCH_LEAF_PILE.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.ENCHANTED_BIRCH_LEAF_PILE.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.MEADOW_SAGE.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BARLEY.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.CATTAIL.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TASSEL.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DAY_LILY.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.ASHEN_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.ALPHA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.APPLE_OAK_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.BAMBOO_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.BAOBAB_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.BLACKWOOD_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.CACTUS_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.COBALT_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.MAGNOLIA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.CYPRESS_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.DEAD_PINE_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.DEAD_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.FLOWERING_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.GOLDEN_LARCH_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.JOSHUA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.KAPOK_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.LARCH_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.MAPLE_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.MAUVE_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.ORANGE_MAPLE_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.PALM_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.PINE_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.REDWOOD_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.RED_MAPLE_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.BRIMWOOD_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.SILVER_BIRCH_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.SMALL_OAK_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.SOCOTRA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getSapling());
        this.dropSelf(RuBlocks.WILLOW_NATURAL_SET.getSapling());
        this.add(RuBlocks.ASHEN_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ACACIA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BAOBAB_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BIRCH_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BLACKWOOD_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BRIMWOOD_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MAGNOLIA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.CHERRY_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.CYPRESS_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DARK_OAK_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DEAD_PINE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.DEAD_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.EUCALYPTUS_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.FLOWERING_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.GOLDEN_LARCH_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.JOSHUA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.JUNGLE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.KAPOK_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.LARCH_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MANGROVE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MAPLE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MAUVE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.OAK_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ORANGE_MAPLE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PALM_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PINE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.REDWOOD_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.RED_MAPLE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SILVER_BIRCH_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SOCOTRA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.SPRUCE_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.WILLOW_NATURAL_SET.getShrub(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.BLUE_BIOSHROOM.get());
        this.dropSelf(RuBlocks.GREEN_BIOSHROOM.get());
        this.dropSelf(RuBlocks.PINK_BIOSHROOM.get());
        this.dropSelf(RuBlocks.YELLOW_BIOSHROOM.get());
        this.add(RuBlocks.TALL_BLUE_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TALL_GREEN_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TALL_PINK_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.TALL_YELLOW_BIOSHROOM.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.ICICLE.get(), x$0 -> this.createSilkTouchOnlyTable((ItemLike)x$0));
        this.dropSelf(RuBlocks.BARREL_CACTUS.get());
        this.dropSelf(RuBlocks.CAVE_HYSSOP.get());
        this.dropSelf(RuBlocks.DUCKWEED.get());
        this.add(RuBlocks.SPANISH_MOSS.get(), RuBlockLootTables::createShearsOnlyDrop);
        this.add(RuBlocks.SPANISH_MOSS_PLANT.get(), RuBlockLootTables::createShearsOnlyDrop);
        this.add(RuBlocks.KAPOK_VINES.get(), RuBlockLootTables::createShearsOnlyDrop);
        this.add(RuBlocks.KAPOK_VINES_PLANT.get(), RuBlockLootTables::createShearsOnlyDrop);
        this.dropSelf(RuBlocks.FLOWERING_LILY_PAD.get());
        this.add(RuBlocks.GIANT_LILY_PAD.get(), block -> this.createSingleItemTable((ItemLike)RuBlocks.FLOWERING_LILY_PAD.get()));
        this.add(RuBlocks.SALMONBERRY_BUSH.get(), block -> (LootTable.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.SALMONBERRY_BUSH.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SalmonBerryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.SALMONBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE)))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)RuBlocks.SALMONBERRY_BUSH.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SweetBerryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuItems.SALMONBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE))))));
        this.add(RuBlocks.POTTED_ALPHA_DANDELION.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ALPHA_DANDELION.get()));
        this.add(RuBlocks.POTTED_ALPHA_ROSE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ALPHA_ROSE.get()));
        this.add(RuBlocks.POTTED_ASTER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ASTER.get()));
        this.add(RuBlocks.POTTED_BLEEDING_HEART.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLEEDING_HEART.get()));
        this.add(RuBlocks.POTTED_DAISY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DAISY.get()));
        this.add(RuBlocks.POTTED_FELICIA_DAISY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.FELICIA_DAISY.get()));
        this.add(RuBlocks.POTTED_DORCEL.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DORCEL.get()));
        this.add(RuBlocks.POTTED_FIREWEED.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.FIREWEED.get()));
        this.add(RuBlocks.POTTED_GLISTERING_BLOOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GLISTERING_BLOOM.get()));
        this.add(RuBlocks.POTTED_HIBISCUS.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.HIBISCUS.get()));
        this.add(RuBlocks.POTTED_HYSSOP.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.HYSSOP.get()));
        this.add(RuBlocks.POTTED_MALLOW.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MALLOW.get()));
        this.add(RuBlocks.POTTED_POPPY_BUSH.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.POPPY_BUSH.get()));
        this.add(RuBlocks.POTTED_SALMON_POPPY_BUSH.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SALMON_POPPY_BUSH.get()));
        this.add(RuBlocks.POTTED_TSUBAKI.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TSUBAKI.get()));
        this.add(RuBlocks.POTTED_WARATAH.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WARATAH.get()));
        this.add(RuBlocks.POTTED_WHITE_TRILLIUM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WHITE_TRILLIUM.get()));
        this.add(RuBlocks.POTTED_WILTING_TRILLIUM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WILTING_TRILLIUM.get()));
        this.add(RuBlocks.POTTED_BLUE_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_LUPINE.get()));
        this.add(RuBlocks.POTTED_PINK_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_LUPINE.get()));
        this.add(RuBlocks.POTTED_PURPLE_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PURPLE_LUPINE.get()));
        this.add(RuBlocks.POTTED_RED_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.RED_LUPINE.get()));
        this.add(RuBlocks.POTTED_YELLOW_LUPINE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.YELLOW_LUPINE.get()));
        this.add(RuBlocks.POTTED_ORANGE_CONEFLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ORANGE_CONEFLOWER.get()));
        this.add(RuBlocks.POTTED_PURPLE_CONEFLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PURPLE_CONEFLOWER.get()));
        for (Map.Entry entry : RuBlocks.POTTED_SNOWBELLES.getMap().entrySet()) {
            this.add((Block)entry.getValue(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SNOWBELLES.getMap().get(entry.getKey())));
        }
        this.add(RuBlocks.POTTED_DAY_LILY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DAY_LILY.get()));
        this.add(RuBlocks.POTTED_MEADOW_SAGE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MEADOW_SAGE.get()));
        this.add(RuBlocks.POTTED_CAVE_HYSSOP.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CAVE_HYSSOP.get()));
        this.add(RuBlocks.POTTED_BARREL_CACTUS.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BARREL_CACTUS.get()));
        this.add(RuBlocks.POTTED_DUSKTRAP.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DUSKTRAP.get()));
        this.add(RuBlocks.POTTED_CORPSE_FLOWER.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CORPSE_FLOWER.get()));
        this.add(RuBlocks.POTTED_COBALT_EARLIGHT.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.COBALT_EARLIGHT.get()));
        this.add(RuBlocks.POTTED_TALL_COBALT_EARLIGHT.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_COBALT_EARLIGHT.get()));
        this.add(RuBlocks.POTTED_MYCOTOXIC_DAISY.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MYCOTOXIC_DAISY.get()));
        this.add(RuBlocks.POTTED_GLISTER_SPIRE.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GLISTER_SPIRE.get()));
        this.add(RuBlocks.POTTED_BLUE_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_GREEN_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_PINK_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_YELLOW_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_BLUE_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_GREEN_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_PINK_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_PINK_BIOSHROOM.get()));
        this.add(RuBlocks.POTTED_TALL_YELLOW_BIOSHROOM.get(), this.createPotFlowerItemTable((ItemLike)RuBlocks.TALL_YELLOW_BIOSHROOM.get()));
        this.add(RuBlocks.ASHEN_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ASHEN_NATURAL_SET.getSapling()));
        this.add(RuBlocks.ALPHA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ALPHA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.APPLE_OAK_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.APPLE_OAK_NATURAL_SET.getSapling()));
        this.add(RuBlocks.BAMBOO_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BAMBOO_NATURAL_SET.getSapling()));
        this.add(RuBlocks.BAOBAB_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BAOBAB_NATURAL_SET.getSapling()));
        this.add(RuBlocks.BLACKWOOD_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLACKWOOD_NATURAL_SET.getSapling()));
        this.add(RuBlocks.BRIMWOOD_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getSapling()));
        this.add(RuBlocks.COBALT_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.COBALT_NATURAL_SET.getSapling()));
        this.add(RuBlocks.CACTUS_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CACTUS_NATURAL_SET.getSapling()));
        this.add(RuBlocks.MAGNOLIA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAGNOLIA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.CYPRESS_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.CYPRESS_NATURAL_SET.getSapling()));
        this.add(RuBlocks.DEAD_PINE_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DEAD_PINE_NATURAL_SET.getSapling()));
        this.add(RuBlocks.DEAD_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.DEAD_NATURAL_SET.getSapling()));
        this.add(RuBlocks.EUCALYPTUS_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling()));
        this.add(RuBlocks.FLOWERING_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.FLOWERING_NATURAL_SET.getSapling()));
        this.add(RuBlocks.GOLDEN_LARCH_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.GOLDEN_LARCH_NATURAL_SET.getSapling()));
        this.add(RuBlocks.JOSHUA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.KAPOK_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.KAPOK_NATURAL_SET.getSapling()));
        this.add(RuBlocks.LARCH_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.LARCH_NATURAL_SET.getSapling()));
        this.add(RuBlocks.MAPLE_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAPLE_NATURAL_SET.getSapling()));
        this.add(RuBlocks.MAUVE_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.MAUVE_NATURAL_SET.getSapling()));
        this.add(RuBlocks.ORANGE_MAPLE_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ORANGE_MAPLE_NATURAL_SET.getSapling()));
        this.add(RuBlocks.PALM_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PALM_NATURAL_SET.getSapling()));
        this.add(RuBlocks.PINE_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINE_NATURAL_SET.getSapling()));
        this.add(RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.REDWOOD_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.REDWOOD_NATURAL_SET.getSapling()));
        this.add(RuBlocks.RED_MAPLE_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.RED_MAPLE_NATURAL_SET.getSapling()));
        this.add(RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getSapling()));
        this.add(RuBlocks.SILVER_BIRCH_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SILVER_BIRCH_NATURAL_SET.getSapling()));
        this.add(RuBlocks.SMALL_OAK_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SMALL_OAK_NATURAL_SET.getSapling()));
        this.add(RuBlocks.SOCOTRA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.SOCOTRA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getSapling()));
        this.add(RuBlocks.WILLOW_NATURAL_SET.getPottedSapling(), this.createPotFlowerItemTable((ItemLike)RuBlocks.WILLOW_NATURAL_SET.getSapling()));
        this.add(RuBlocks.BLUE_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_BLUE_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.BLUE_BIOSHROOM.get()));
        this.add(RuBlocks.GREEN_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_GREEN_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.GREEN_BIOSHROOM.get()));
        this.add(RuBlocks.PINK_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.PINK_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_PINK_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.PINK_BIOSHROOM.get()));
        this.add(RuBlocks.YELLOW_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()));
        this.add(RuBlocks.GLOWING_YELLOW_BIOSHROOM_BLOCK.get(), block -> this.createMushroomBlockDrop((Block)block, (ItemLike)RuBlocks.YELLOW_BIOSHROOM.get()));
        this.dropSelf(RuBlocks.BAMBOO_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_BAMBOO_LOG.get());
        this.dropSelf(RuBlocks.SMALL_OAK_LOG.get());
        this.dropSelf(RuBlocks.STRIPPED_SMALL_OAK_LOG.get());
        this.dropSelf(RuBlocks.SAGUARO_CACTUS.get());
        this.add(RuBlocks.ALPHA_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.ALPHA_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.APPLE_OAK_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.APPLE_OAK_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ASHEN_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.ASHEN_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BAMBOO_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.BAMBOO_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BAOBAB_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.BAOBAB_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BLACKWOOD_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.BLACKWOOD_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.COBALT_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.COBALT_NATURAL_SET.getSapling(), COBALT_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.MAGNOLIA_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.MAGNOLIA_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.CYPRESS_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.CYPRESS_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.DEAD_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.DEAD_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.DEAD_PINE_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.DEAD_PINE_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.EUCALYPTUS_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.EUCALYPTUS_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.FLOWERING_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.FLOWERING_NATURAL_SET.getSapling(), FLOWERING_OAK_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.GOLDEN_LARCH_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.GOLDEN_LARCH_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.JOSHUA_NATURAL_SET.getLeaves(), block -> this.createDoublePlantWithSeedDropsNoGrass((Block)block, RuBlocks.JOSHUA_NATURAL_SET.getLeaves(), (ItemLike)RuBlocks.JOSHUA_NATURAL_SET.getSapling(), JOSHUA_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.KAPOK_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.KAPOK_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.LARCH_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.LARCH_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.MAPLE_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.MAPLE_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.MAUVE_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.MAUVE_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ORANGE_MAPLE_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.ORANGE_MAPLE_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.PALM_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.PALM_NATURAL_SET.getSapling(), PALM_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.PINE_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.PINE_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.BLUE_MAGNOLIA_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.PINK_MAGNOLIA_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.REDWOOD_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.REDWOOD_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.RED_MAPLE_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.RED_MAPLE_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.BRIMWOOD_NATURAL_SET.getLeaves(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)RuBlocks.BRIMWOOD_NATURAL_SET.getSapling()))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_SAPLING_CHANCES))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.HAS_NO_SHEARS_OR_SILK_TOUCH)));
        this.add(RuBlocks.SILVER_BIRCH_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.SILVER_BIRCH_NATURAL_SET.getSapling(), ASPEN_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.SMALL_OAK_NATURAL_SET.getLeaves(), block -> this.createOakLeavesDrops((Block)block, RuBlocks.SMALL_OAK_NATURAL_SET.getSapling(), SMALL_OAK_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.SOCOTRA_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.SOCOTRA_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.ENCHANTED_BIRCH_NATURAL_SET.getSapling(), ASPEN_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.WHITE_MAGNOLIA_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.WILLOW_NATURAL_SET.getLeaves(), block -> this.createLeavesDrops((Block)block, RuBlocks.WILLOW_NATURAL_SET.getSapling(), NORMAL_LEAVES_SAPLING_CHANCES));
        this.add(RuBlocks.ACACIA_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.BAOBAB_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.BIRCH_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.BLACKWOOD_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MAGNOLIA_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.CYPRESS_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.CHERRY_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.DARK_OAK_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.DEAD_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.EUCALYPTUS_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.JOSHUA_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.JUNGLE_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.KAPOK_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.LARCH_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MANGROVE_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MAPLE_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.MAUVE_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.OAK_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.PALM_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.PINE_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.REDWOOD_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.SILVER_BIRCH_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.SOCOTRA_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.SPRUCE_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.WILLOW_NATURAL_SET.getBranch(), block -> this.createShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)((LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK)))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)4.0f)).when(HAS_SHEARS.invert())));
        this.add(RuBlocks.PEAT_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.PEAT_DIRT.get()));
        this.dropSelf(RuBlocks.PEAT_DIRT.get());
        this.add(RuBlocks.PEAT_DIRT_PATH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.PEAT_DIRT.get()));
        this.dropSelf(RuBlocks.PEAT_COARSE_DIRT.get());
        this.dropSelf(RuBlocks.PEAT_PODZOL.get());
        this.dropSelf(RuBlocks.PEAT_MUD.get());
        this.add(RuBlocks.PEAT_FARMLAND.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.PEAT_DIRT.get()));
        this.add(RuBlocks.SILT_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.SILT_DIRT.get()));
        this.dropSelf(RuBlocks.SILT_DIRT.get());
        this.add(RuBlocks.SILT_DIRT_PATH.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.SILT_DIRT.get()));
        this.dropSelf(RuBlocks.SILT_COARSE_DIRT.get());
        this.dropSelf(RuBlocks.SILT_PODZOL.get());
        this.dropSelf(RuBlocks.SILT_MUD.get());
        this.add(RuBlocks.SILT_FARMLAND.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.SILT_DIRT.get()));
        this.add(RuBlocks.ALPHA_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.DIRT));
        this.dropSelf(RuBlocks.ASHEN_DIRT.get());
        this.dropSelf(RuBlocks.CHALK.get());
        this.add(RuBlocks.CHALK_GRASS_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.CHALK.get()));
        this.dropSelf(RuBlocks.CHALK_BRICKS.get());
        this.add(RuBlocks.CHALK_BRICK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf(RuBlocks.CHALK_BRICK_STAIRS.get());
        this.dropSelf(RuBlocks.CHALK_PILLAR.get());
        this.add(RuBlocks.CHALK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf(RuBlocks.CHALK_STAIRS.get());
        this.dropSelf(RuBlocks.POLISHED_CHALK.get());
        this.add(RuBlocks.POLISHED_CHALK_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf(RuBlocks.POLISHED_CHALK_STAIRS.get());
        this.dropSelf(RuBlocks.ARGILLITE.get());
        this.add(RuBlocks.MOSSY_STONE.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.MOSSY_COBBLESTONE));
        this.dropSelf(RuBlocks.HYACINTH_LAMP.get());
        this.dropSelf(RuBlocks.HYACINTH_BLOOM.get());
        this.add(RuBlocks.HYACINTH_FLOWERS.get(), block -> this.createMultifaceBlockDrops((Block)block, HAS_SHEARS));
        this.dropSelf(RuBlocks.TALL_HYACINTH_STOCK.get());
        this.add(RuBlocks.ASH.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)Items.FLINT, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.SILK_TOUCH), (float[])new float[]{1.0f}))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT)))));
        this.add(RuBlocks.VOLCANIC_ASH.get(), block -> this.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)Items.FLINT, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.SILK_TOUCH), (float[])new float[]{1.0f}))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT)))));
        this.dropSelf(RuBlocks.ASH_VENT.get());
        for (WoodSet woodSet : RuBlocks.WOOD_SETS) {
            if (woodSet.getLog() != null) {
                this.dropSelf(woodSet.getLog());
            }
            if (woodSet.getStrippedLog() != null) {
                this.dropSelf(woodSet.getStrippedLog());
            }
            if (woodSet.getWood() != null) {
                this.dropSelf(woodSet.getWood());
            }
            if (woodSet.getStrippedWood() != null) {
                this.dropSelf(woodSet.getStrippedWood());
            }
            if (woodSet.getPlanks() != null) {
                this.dropSelf(woodSet.getPlanks());
            }
            if (woodSet.getStairs() != null) {
                this.dropSelf(woodSet.getStairs());
            }
            if (woodSet.getSlab() != null) {
                this.add(woodSet.getSlab(), this.createSlabItemTable(woodSet.getSlab()));
            }
            if (woodSet.getFence() != null) {
                this.dropSelf(woodSet.getFence());
            }
            if (woodSet.getDoor() != null) {
                this.add(woodSet.getDoor(), this.createDoorTable(woodSet.getDoor()));
            }
            if (woodSet.getFenceGate() != null) {
                this.dropSelf(woodSet.getFenceGate());
            }
            if (woodSet.getTrapdoor() != null) {
                this.dropSelf(woodSet.getTrapdoor());
            }
            if (woodSet.getPressurePlate() != null) {
                this.dropSelf(woodSet.getPressurePlate());
            }
            if (woodSet.getButton() != null) {
                this.dropSelf(woodSet.getButton());
            }
            if (woodSet.getSign() != null) {
                this.dropSelf(woodSet.getSign());
            }
            if (woodSet.getWallSign() != null) {
                this.add(woodSet.getWallSign(), this.createSingleItemTable((ItemLike)woodSet.getSign()));
            }
            if (woodSet.getHangingSign() != null) {
                this.dropSelf(woodSet.getHangingSign());
            }
            if (woodSet.getWallHangingSign() == null) continue;
            this.add(woodSet.getWallHangingSign(), this.createSingleItemTable((ItemLike)woodSet.getHangingSign()));
        }
        this.add(RuBlocks.BRIMWOOD_WOOD_SET.getLogMagma(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)RuBlocks.BRIMWOOD_WOOD_SET.getLog()));
        for (Block block3 : RuBlocks.PAINTED_PLANKS.getAll()) {
            this.dropSelf(block3);
        }
        for (Block block4 : RuBlocks.PAINTED_STAIRS.getAll()) {
            this.dropSelf(block4);
        }
        for (Block block5 : RuBlocks.PAINTED_SLABS.getAll()) {
            this.add(block5, x$0 -> this.createSlabItemTable((Block)x$0));
        }
        this.dropSelf(RuBlocks.BLACKSTONE_CLUSTER.get());
        this.add(RuBlocks.OVERGROWN_BONE_BLOCK.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Items.BONE_BLOCK));
        this.add(RuBlocks.BRIMSPROUT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
        this.dropSelf(RuBlocks.BRIMSPROUT.get());
        this.dropSelf(RuBlocks.COBALT_EARLIGHT.get());
        this.add(RuBlocks.TALL_COBALT_EARLIGHT.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.COBALT_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.BLACKSTONE));
        this.dropSelf(RuBlocks.COBALT_OBSIDIAN.get());
        this.dropSelf(RuBlocks.COBALT_ROOTS.get());
        this.add(RuBlocks.HANGING_EARLIGHT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.66f, 0.78f, 0.9f, 1.0f}))));
        this.add(RuBlocks.HANGING_EARLIGHT_PLANT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.66f, 0.78f, 0.9f, 1.0f}))));
        this.add(RuBlocks.GLISTERING_IVY.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.GLISTERING_IVY_PLANT.get(), block -> this.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)block).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f}))));
        this.add(RuBlocks.GLISTERING_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
        this.dropSelf(RuBlocks.GLISTERING_SPROUT.get());
        this.dropSelf(RuBlocks.GLISTERING_BLOOM.get());
        this.dropSelf(RuBlocks.GLISTERING_FERN.get());
        this.dropSelf(RuBlocks.GLISTERING_WART.get());
        this.add(RuBlocks.GLISTER_BULB.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.GLISTER_SPIRE.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.add(RuBlocks.MYCOTOXIC_MUSHROOMS.get(), x$0 -> this.createPetalsDrops((Block)x$0));
        this.add(RuBlocks.MYCOTOXIC_DAISY.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf(RuBlocks.MYCOTOXIC_GRASS.get());
        this.add(RuBlocks.MYCOTOXIC_NYLIUM.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)Blocks.NETHERRACK));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().contains("regions_unexplored")).map(Map.Entry::getValue).toList();
    }

    protected LootTable.Builder createMushroomBlockDrop(Block block, ItemLike item) {
        return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0)))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDropsNoGrass(Block block, Block block1, ItemLike item, float ... chances) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)item))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.holderOrThrow(Enchantments.FORTUNE), (float[])chances)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDropsNoGrass(Block block) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    protected LootTable.Builder createShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
        return RuBlockLootTables.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)HAS_SHEARS, builder);
    }

    protected static LootTable.Builder createShearsOnlyDrop(ItemLike item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }

    protected LootTable.Builder createSilkTouchOrShearsDispatchTable(Block block, LootPoolEntryContainer.Builder<?> builder) {
        return RuBlockLootTables.createSelfDropDispatchTable((Block)block, (LootItemCondition.Builder)this.HAS_SHEARS_OR_SILK_TOUCH, builder);
    }

    protected LootTable.Builder createLeavesDrops(Block block, Block block1, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(block, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)block1))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])chances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.HAS_NO_SHEARS_OR_SILK_TOUCH).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
    }

    protected LootTable.Builder createOakLeavesDrops(Block block, Block block1, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(block, block1, chances).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.HAS_NO_SHEARS_OR_SILK_TOUCH).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.APPLE))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDrops(Block block, Block block1) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{block}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }
}

