/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.block.set;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public final class ColoredSet {
    private final Map<DyeColor, Supplier<Block>> blocks;

    public ColoredSet(Function<DyeColor, Supplier<Block>> factory) {
        EnumMap<DyeColor, Supplier<Block>> blocks = new EnumMap<DyeColor, Supplier<Block>>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            blocks.put(color, factory.apply(color));
        }
        this.blocks = blocks;
    }

    public ArrayList<Block> getAll() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Map.Entry<DyeColor, Supplier<Block>> entry : this.blocks.entrySet()) {
            blocks.add(entry.getValue().get());
        }
        return blocks;
    }

    public Map<DyeColor, Block> getMap() {
        EnumMap<DyeColor, Block> map = new EnumMap<DyeColor, Block>(DyeColor.class);
        for (Map.Entry<DyeColor, Supplier<Block>> entry : this.blocks.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    public Block get(DyeColor color) {
        return this.blocks.get(color).get();
    }
}

