/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.tree.decorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.razordevs.deep_aether.block.natural.YagrootVineBlock;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.DADecoratorType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class YagrootVineDecorator
extends TreeDecorator {
    public static final MapCodec<YagrootVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(YagrootVineDecorator::new, vineDecorator -> Float.valueOf(vineDecorator.probability)).stable();
    private final float probability;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)DADecoratorType.YAGVINES.get();
    }

    public YagrootVineDecorator(float probability) {
        this.probability = probability;
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        context.leaves().forEach(blockPos -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextFloat() < this.probability && context.isAir(blockpos = blockPos.west())) {
                this.addHangingVine(blockpos, VineBlock.EAST, context);
            }
            if (randomsource.nextFloat() < this.probability && context.isAir(blockpos1 = blockPos.east())) {
                this.addHangingVine(blockpos1, VineBlock.WEST, context);
            }
            if (randomsource.nextFloat() < this.probability && context.isAir(blockpos2 = blockPos.north())) {
                this.addHangingVine(blockpos2, VineBlock.SOUTH, context);
            }
            if (randomsource.nextFloat() < this.probability && context.isAir(blockpos3 = blockPos.south())) {
                this.addHangingVine(blockpos3, VineBlock.NORTH, context);
            }
        });
    }

    private void addHangingVine(BlockPos blockPos, BooleanProperty property, TreeDecorator.Context context) {
        this.placeVine(blockPos, property, context, !context.isAir(blockPos.below()));
        BlockPos blockpos = blockPos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            this.placeVine(blockpos, property, context, !context.isAir(blockPos.below()));
            blockpos = blockpos.below();
        }
    }

    public void placeVine(BlockPos blockPos, BooleanProperty property, TreeDecorator.Context context, Boolean isBottom) {
        context.setBlock(blockPos, (BlockState)((BlockState)((Block)DABlocks.YAGROOT_VINE.get()).defaultBlockState().setValue((Property)property, (Comparable)Boolean.TRUE)).setValue((Property)YagrootVineBlock.BOTTOM, (Comparable)isBottom));
    }
}

