/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.tree.decorators;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.DADecoratorType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class GlowingVineDecorator
extends TreeDecorator {
    public static final MapCodec<GlowingVineDecorator> CODEC = Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").xmap(GlowingVineDecorator::new, p_226037_ -> Float.valueOf(p_226037_.probability)).stable();
    private final float probability;

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)DADecoratorType.GLOWING_VINE.get();
    }

    public GlowingVineDecorator(float p_226031_) {
        this.probability = p_226031_;
    }

    public void place(TreeDecorator.Context pContext) {
        RandomSource randomsource = pContext.random();
        pContext.leaves().forEach(p_226035_ -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos = p_226035_.west())) {
                GlowingVineDecorator.addHangingVine(blockpos, VineBlock.EAST, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos1 = p_226035_.east())) {
                GlowingVineDecorator.addHangingVine(blockpos1, VineBlock.WEST, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos2 = p_226035_.north())) {
                GlowingVineDecorator.addHangingVine(blockpos2, VineBlock.SOUTH, pContext);
            }
            if (randomsource.nextFloat() < this.probability && pContext.isAir(blockpos3 = p_226035_.south())) {
                GlowingVineDecorator.addHangingVine(blockpos3, VineBlock.NORTH, pContext);
            }
        });
    }

    private static void addHangingVine(BlockPos pPos, BooleanProperty pSideProperty, TreeDecorator.Context pContext) {
        Block vine = GlowingVineDecorator.getRandomVine(pContext.random());
        GlowingVineDecorator.placeVine(pPos, pSideProperty, pContext, vine);
        BlockPos blockpos = pPos.below();
        for (int i = 4; pContext.isAir(blockpos) && i > 0; --i) {
            GlowingVineDecorator.placeVine(blockpos, pSideProperty, pContext, vine);
            blockpos = blockpos.below();
        }
    }

    private static Block getRandomVine(RandomSource random) {
        if (random.nextInt(5) == 1) {
            return (Block)DABlocks.GLOWING_VINE.get();
        }
        return Blocks.VINE;
    }

    private static void placeVine(BlockPos pPos, BooleanProperty pSideProperty, TreeDecorator.Context context, Block block) {
        context.setBlock(pPos, (BlockState)block.defaultBlockState().setValue((Property)pSideProperty, (Comparable)Boolean.TRUE));
    }
}

