/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.datagen.tags.DATags;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.features.configuration.AercloudCloudConfiguration;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluids;

public class RainAercloudCloudFeature
extends Feature<AercloudCloudConfiguration> {
    public static final PerlinSimplexNoise NOISE = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(42L), List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    public static final int lowestY = 145;

    public RainAercloudCloudFeature(Codec<AercloudCloudConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<AercloudCloudConfiguration> context) {
        WorldGenLevel reader = context.level();
        BlockPos pos = context.origin();
        AercloudCloudConfiguration config = (AercloudCloudConfiguration)context.config();
        BlockState block = config.block().getState(context.random(), pos);
        this.place(reader, pos, block, context.random().nextInt(400, 3000));
        return true;
    }

    public void place(WorldGenLevel reader, BlockPos pos, BlockState block, int sterlingAercloudCount) {
        boolean goAgainstX = !reader.getBiome(pos.relative(Direction.Axis.X, 16)).is(DATags.Biomes.IS_RAIN_CLOUD);
        boolean goAgainstNegativeX = !reader.getBiome(pos.relative(Direction.Axis.X, -16)).is(DATags.Biomes.IS_RAIN_CLOUD);
        boolean goAgainstZ = !reader.getBiome(pos.relative(Direction.Axis.Z, 16)).is(DATags.Biomes.IS_RAIN_CLOUD);
        boolean goAgainstNegativeZ = !reader.getBiome(pos.relative(Direction.Axis.Z, -16)).is(DATags.Biomes.IS_RAIN_CLOUD);
        boolean goAgainstXAndZ = !reader.getBiome(pos.relative(Direction.Axis.X, 16).relative(Direction.Axis.Z, 16)).is(DATags.Biomes.IS_RAIN_CLOUD) && !goAgainstX && !goAgainstZ;
        boolean goAgainstXAndNegativeZ = !reader.getBiome(pos.relative(Direction.Axis.X, 16).relative(Direction.Axis.Z, -16)).is(DATags.Biomes.IS_RAIN_CLOUD) && !goAgainstX && !goAgainstNegativeZ;
        boolean goAgainstNegativeXAndZ = !reader.getBiome(pos.relative(Direction.Axis.X, -16).relative(Direction.Axis.Z, 16)).is(DATags.Biomes.IS_RAIN_CLOUD) && !goAgainstNegativeX && !goAgainstZ;
        boolean goAgainstNegativeXAndNegativeZ = !reader.getBiome(pos.relative(Direction.Axis.X, -16).relative(Direction.Axis.Z, -16)).is(DATags.Biomes.IS_RAIN_CLOUD) && !goAgainstNegativeX && !goAgainstNegativeZ;
        int chunkX = pos.getX() - pos.getX() % 16;
        int chunkZ = pos.getZ() - pos.getZ() % 16;
        int sterlingCount = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double bottom;
                int xCoord = chunkX + x;
                int zCoord = chunkZ + z;
                double bottomNoiseValue = NOISE.getValue((double)xCoord * 0.02, (double)zCoord * 0.02, false);
                double originalBottom = bottom = Math.abs(Mth.lerp((double)bottomNoiseValue, (double)4.0, (double)2.0));
                double topNoiseValue = NOISE.getValue((double)xCoord * 0.007, (double)zCoord * 0.007, false);
                double top = Mth.lerp((double)topNoiseValue, (double)-2.0, (double)7.0) + 2.0;
                if (top < 3.0) {
                    top -= (3.0 - top) * 2.0;
                }
                double decreaseMultiplier = 1.5;
                double decreaseMultiplierCorner = 4.0;
                if (goAgainstX && x > 8) {
                    bottom += ((double)x - 8.0) / 1.5;
                    top -= ((double)x - 8.0) / 1.5;
                }
                if (goAgainstNegativeX && x <= 8) {
                    bottom += (8.0 - (double)x) / 1.5;
                    top -= (8.0 - (double)x) / 1.5;
                }
                if (goAgainstZ && z > 8) {
                    bottom += ((double)z - 8.0) / 1.5;
                    top -= ((double)z - 8.0) / 1.5;
                }
                if (goAgainstNegativeZ) {
                    if (z < 8) {
                        bottom += (8.0 - (double)z) / 1.5;
                        top -= (8.0 - (double)z) / 1.5;
                    }
                } else if (goAgainstXAndZ) {
                    if (x > 12) {
                        bottom += ((double)x - 12.0) / 4.0;
                        top -= ((double)x - 12.0) / 4.0;
                    }
                    if (z > 12) {
                        bottom += ((double)z - 12.0) / 4.0;
                        top -= ((double)z - 12.0) / 4.0;
                    }
                } else if (goAgainstXAndNegativeZ) {
                    if (x > 12) {
                        bottom += ((double)x - 12.0) / 4.0;
                        top -= ((double)x - 12.0) / 4.0;
                    }
                    if (z < 4) {
                        bottom += (4.0 - (double)z) / 4.0;
                        top -= (4.0 - (double)z) / 4.0;
                    }
                } else if (goAgainstNegativeXAndZ) {
                    if (x < 4) {
                        bottom += (4.0 - (double)x) / 4.0;
                        top -= (4.0 - (double)x) / 4.0;
                    }
                    if (z > 12) {
                        bottom += ((double)z - 12.0) / 4.0;
                        top -= ((double)z - 12.0) / 4.0;
                    }
                } else if (goAgainstNegativeXAndNegativeZ) {
                    if (x < 4) {
                        bottom += (4.0 - (double)x) / 4.0;
                        top -= (4.0 - (double)x) / 4.0;
                    }
                    if (z < 4) {
                        bottom += (4.0 - (double)z) / 4.0;
                        top -= (4.0 - (double)z) / 4.0;
                    }
                }
                int y = Math.round(Math.round(145.0 + bottom - top / 2.0));
                if (top >= 4.0) {
                    this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y), block);
                    ++sterlingCount;
                    ++y;
                    while (y < 153) {
                        reader.setBlock(pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y), Fluids.WATER.defaultFluidState().createLegacyBlock(), 2);
                        ++y;
                    }
                    this.markAboveForPostProcessing(reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(151));
                } else {
                    while ((double)y < 145.0 + top + originalBottom) {
                        if (++sterlingCount > sterlingAercloudCount) {
                            sterlingCount = 0;
                            this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y), ((Block)DABlocks.STERLING_AERCLOUD.get()).defaultBlockState());
                        } else {
                            this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y), block);
                        }
                        ++y;
                    }
                }
                originalBottom *= 4.0;
                int a = 0;
                if (originalBottom < 12.0) {
                    a = (int)(12.0 - originalBottom);
                }
                y = 12 + a;
                while ((double)y > originalBottom) {
                    this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y + 145 + 20), block);
                    --y;
                }
            }
        }
    }
}

