/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.world.feature.features.configuration.FallenTreeConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class FallenTreeFeature
extends Feature<FallenTreeConfiguration> {
    public FallenTreeFeature(Codec<FallenTreeConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<FallenTreeConfiguration> context) {
        WorldGenLevel reader = context.level();
        RandomSource rand = context.random();
        BlockPos pos = context.origin();
        FallenTreeConfiguration config = (FallenTreeConfiguration)context.config();
        BlockState block = config.block().getState(context.random(), pos);
        int length = rand.nextInt(config.min(), config.max());
        int gap = rand.nextInt(2, 4);
        int MAX_DEPTH = 4;
        Direction direction = FallenTreeFeature.getRandomDirectionYExcluded(rand);
        if (!this.canPlace((LevelReader)reader, pos)) {
            return false;
        }
        if (this.canPlace((LevelReader)reader, (pos = pos.relative(direction, gap)).below())) {
            return false;
        }
        boolean follow_terrain = rand.nextBoolean();
        if (follow_terrain) {
            BlockPos tempPos = pos;
            for (i = 0; i < length; ++i) {
                if (this.canPlace((LevelReader)reader, tempPos.relative(direction, i).below()) && this.canPlace((LevelReader)reader, tempPos.relative(direction, i))) {
                    boolean f = false;
                    for (int ii = 1; ii < 4; ++ii) {
                        if (this.canPlace((LevelReader)reader, tempPos.relative(direction, i).below(ii))) continue;
                        tempPos = tempPos.below(ii - 1);
                        f = true;
                    }
                    if (f) continue;
                    return false;
                }
                if (this.canPlace((LevelReader)reader, tempPos.relative(direction, i))) continue;
                return false;
            }
        } else {
            int posWithoutBlockBelow = 0;
            for (i = 0; i < length; ++i) {
                if (!this.canPlace((LevelReader)reader, pos.relative(direction, i))) {
                    return false;
                }
                posWithoutBlockBelow = this.canPlace((LevelReader)reader, pos.relative(direction, i).below()) ? ++posWithoutBlockBelow : 0;
                if (posWithoutBlockBelow <= 2) continue;
                return false;
            }
        }
        this.setBlock((LevelWriter)reader, pos.relative(direction.getOpposite(), gap), block);
        if (follow_terrain) {
            for (int i = 0; i < length; ++i) {
                if (this.canPlace((LevelReader)reader, pos.relative(direction, i).below())) {
                    for (int ii = 1; ii < 4; ++ii) {
                        if (this.canPlace((LevelReader)reader, pos.relative(direction, i).below(ii))) continue;
                        pos = pos.below(ii - 1);
                    }
                }
                this.setBlock((LevelWriter)reader, pos.relative(direction, i), (BlockState)block.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
                this.addDecorators(reader, pos, config.decorators().getState(context.random(), pos), context.random(), direction);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.setBlock((LevelWriter)reader, pos.relative(direction, i), (BlockState)block.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)direction.getAxis()));
                this.addDecorators(reader, pos, config.decorators().getState(context.random(), pos), context.random(), direction);
            }
        }
        return true;
    }

    public boolean canPlace(LevelReader reader, BlockPos pos) {
        BlockState state = reader.getBlockState(pos);
        return reader.isEmptyBlock(pos) || state.is(BlockTags.LEAVES) || state.canBeReplaced() || !state.isCollisionShapeFullBlock((BlockGetter)reader, pos);
    }

    public void addDecorators(WorldGenLevel reader, BlockPos pos, BlockState block, RandomSource random, Direction direction) {
        if (random.nextInt(7) == 1 && this.canPlace((LevelReader)reader, pos.above())) {
            this.setBlock((LevelWriter)reader, pos.above(), block);
        }
        if (random.nextInt(4) == 1 && this.canPlace((LevelReader)reader, pos.relative(direction).above())) {
            this.setBlock((LevelWriter)reader, pos.relative(direction).above(), block);
        }
        if (random.nextInt(7) == 1 && this.canPlace((LevelReader)reader, pos.relative(direction.getClockWise())) && !this.canPlace((LevelReader)reader, pos.relative(direction.getClockWise()).below())) {
            this.setBlock((LevelWriter)reader, pos.relative(direction.getClockWise()), block);
        }
        if (random.nextInt(7) == 1 && this.canPlace((LevelReader)reader, pos.relative(direction.getCounterClockWise())) && !this.canPlace((LevelReader)reader, pos.relative(direction.getCounterClockWise()).below())) {
            this.setBlock((LevelWriter)reader, pos.relative(direction.getClockWise()), block);
        }
    }

    public static Direction getRandomDirectionYExcluded(RandomSource random) {
        int a = random.nextInt(3);
        if (a == 0) {
            return Direction.NORTH;
        }
        if (a == 1) {
            return Direction.SOUTH;
        }
        if (a == 2) {
            return Direction.EAST;
        }
        return Direction.WEST;
    }
}

