/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.razordevs.deep_aether.client.model.GentleWindModel;
import io.github.razordevs.deep_aether.client.renderer.DAModelLayers;
import io.github.razordevs.deep_aether.entity.living.GentleWind;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class GentleWindRenderer
extends MobRenderer<GentleWind, GentleWindModel> {
    public GentleWindRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GentleWindModel(context.bakeLayer(DAModelLayers.GENTLE_WIND)), 0.5f);
    }

    public ResourceLocation getTextureLocation(GentleWind pEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"textures/entity/gentle_wind.png");
    }

    public void render(GentleWind gentleWind, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.pushPose();
        boolean flag = gentleWind.isWrappedAroundNeck();
        gentleWind.setInvisible(flag);
        ((GentleWindModel)this.model).root.visible = !flag;
        ((GentleWindModel)this.model).head.visible = !flag;
        for (ModelPart part : ((GentleWindModel)this.model).body) {
            part.visible = !flag;
        }
        ((GentleWindModel)this.model).attackTime = this.getAttackAnim((LivingEntity)gentleWind, partialTicks);
        float f = Mth.rotLerp((float)partialTicks, (float)gentleWind.yBodyRotO, (float)gentleWind.yBodyRot);
        float f1 = Mth.rotLerp((float)partialTicks, (float)gentleWind.yHeadRotO, (float)gentleWind.yHeadRot);
        float f2 = f1 - f;
        float f6 = Mth.lerp((float)partialTicks, (float)gentleWind.xRotO, (float)gentleWind.getXRot());
        if (GentleWindRenderer.isEntityUpsideDown((LivingEntity)gentleWind)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        f2 = Mth.wrapDegrees((float)f2);
        float f8 = gentleWind.getScale();
        matrixStack.scale(f8, f8, f8);
        float f9 = this.getBob(gentleWind, partialTicks);
        this.setupRotations(gentleWind, matrixStack, f9, f, partialTicks, f8);
        matrixStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale((LivingEntity)gentleWind, matrixStack, partialTicks);
        matrixStack.translate(0.0f, -1.501f, 0.0f);
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (gentleWind.isAlive()) {
            f4 = gentleWind.walkAnimation.speed(partialTicks);
            f5 = gentleWind.walkAnimation.position(partialTicks);
            if (f4 > 1.0f) {
                f4 = 1.0f;
            }
        }
        ((GentleWindModel)this.model).prepareMobModel((Entity)gentleWind, f5, f4, partialTicks);
        ((GentleWindModel)this.model).setupAnim(gentleWind, f5, f4, f9, f2, f6);
        RenderType rendertype = ((GentleWindModel)this.model).renderType(this.getTextureLocation(gentleWind));
        VertexConsumer vertexconsumer = buffer.getBuffer(rendertype);
        int i = GentleWindRenderer.getOverlayCoords((LivingEntity)gentleWind, (float)this.getWhiteOverlayProgress((LivingEntity)gentleWind, partialTicks));
        ((GentleWindModel)this.model).head.render(matrixStack, vertexconsumer, packedLight, i, gentleWind.getFromColor(0));
        ((GentleWindModel)this.model).body[0].render(matrixStack, vertexconsumer, packedLight, i, gentleWind.getFromColor(1));
        ((GentleWindModel)this.model).body[1].render(matrixStack, vertexconsumer, packedLight, i, gentleWind.getFromColor(2));
        ((GentleWindModel)this.model).body[2].render(matrixStack, vertexconsumer, packedLight, i, gentleWind.getFromColor(3));
        ((GentleWindModel)this.model).body[3].render(matrixStack, vertexconsumer, packedLight, i, gentleWind.getFromColor(4));
        matrixStack.popPose();
        if (this.shouldShowName((Mob)gentleWind) && gentleWind.getDisplayName() != null && !gentleWind.isWrappedAroundNeck()) {
            this.renderNameTag((Entity)gentleWind, gentleWind.getDisplayName(), matrixStack, buffer, packedLight, partialTicks);
        }
    }

    protected void setupRotations(GentleWind pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks, float scale) {
        super.setupRotations((LivingEntity)pEntityLiving, pPoseStack, pAgeInTicks, pRotationYaw, pPartialTicks, scale);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)pAgeInTicks, (float)pEntityLiving.xRotO, (float)pEntityLiving.getXRot())));
    }

    protected float getBob(GentleWind eots, float partialTicks) {
        return partialTicks;
    }
}

