/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.razordevs.deep_aether.client.model.BabyZephyrModel;
import io.github.razordevs.deep_aether.client.renderer.DAModelLayers;
import io.github.razordevs.deep_aether.entity.living.BabyZephyr;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BabyZephyrRenderer
extends MobRenderer<BabyZephyr, BabyZephyrModel> {
    public BabyZephyrRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new BabyZephyrModel(context.bakeLayer(DAModelLayers.BABY_ZEPHYR)), 0.5f);
    }

    protected void scale(BabyZephyr zephyr, PoseStack poseStack, float partialTicks) {
        float f = Math.min(Mth.lerp((float)partialTicks, (float)zephyr.getCloudScale(), (float)(zephyr.getCloudScale() + zephyr.getCloudScaleAdd())), 38.0f);
        float f1 = f / 38.0f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        f1 = 1.0f / ((float)Math.pow(f1, 5.0) * 2.0f + 1.0f);
        float f2 = (8.0f + f1) / 2.0f;
        float f3 = (8.0f + 1.0f / f1) / 2.0f;
        poseStack.scale(f3, f2, f3);
        poseStack.translate(0.0, 0.55, 0.0);
    }

    public ResourceLocation getTextureLocation(BabyZephyr pEntity) {
        return ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"textures/entity/baby_zephyr.png");
    }
}

