/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.entity.living.Windfly;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class WindflyModel
extends EntityModel<Windfly> {
    private final ModelPart body;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart bb_main;

    public WindflyModel(ModelPart root) {
        this.body = root.getChild("body");
        this.leftWing = root.getChild("leftWing");
        this.rightWing = root.getChild("rightWing");
        this.bb_main = root.getChild("bb_main");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.25f, -6.0f, 3.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)20.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(-34, 27).addBox(-1.25f, 0.0f, -8.25f, 23.0f, 0.0f, 34.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.5f, (float)19.0f, (float)-0.75f));
        partdefinition.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(-34, 27).mirror().addBox(-21.75f, 0.0f, -8.25f, 23.0f, 0.0f, 34.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.5f, (float)19.0f, (float)-0.75f));
        partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(28, 0).addBox(-1.5f, -2.25f, -5.0f, 3.0f, 3.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(0, 14).addBox(-1.5f, -7.0f, -7.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Windfly entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float move;
        float a = 1.0f;
        if (ageInTicks % 20.0f >= 10.0f) {
            a = -1.0f;
        }
        this.rightWing.zRot = move = Mth.lerp((float)(ageInTicks % 10.0f / 10.0f), (float)-0.5f, (float)0.5f) * a;
        this.leftWing.zRot = -move;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.leftWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightWing.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

