/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.entity.living.Venomite;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class VenomiteModel
extends EntityModel<Venomite> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart wingsfront;
    private final ModelPart leftFront;
    private final ModelPart rightFront;
    private final ModelPart wingsback;
    private final ModelPart rightBack;
    private final ModelPart leftBack;
    private final ModelPart tail;

    public VenomiteModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.wingsfront = root.getChild("wingsfront");
        this.leftFront = this.wingsfront.getChild("left");
        this.rightFront = this.wingsfront.getChild("right");
        this.wingsback = root.getChild("wingsback");
        this.rightBack = this.wingsback.getChild("right2");
        this.leftBack = this.wingsback.getChild("left2");
        this.tail = this.body.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(17, 19).addBox(-3.0f, -2.0f, -4.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)-4.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(38, 16).addBox(1.0f, -12.0f, -10.5f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)4.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(38, 16).addBox(-1.0f, -12.0f, -10.5f, 0.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)4.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, -3.0f, -4.0f, 4.0f, 4.6f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 26).addBox(-2.0f, -2.3f, 0.0f, 4.0f, 3.5f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 6).addBox(0.25f, -0.4f, -2.0f, 0.0f, 2.4f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)2.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(0, 4).addBox(-0.25f, -0.4f, -2.0f, 0.0f, 2.4f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)2.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(32, 27).addBox(0.0f, -6.0f, -1.0f, 0.0f, 8.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)3.0f));
        body.addOrReplaceChild("bubble", CubeListBuilder.create().texOffs(13, 8).addBox(-3.0f, -1.0f, -1.6f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)2.6f));
        PartDefinition wingsfront = partdefinition.addOrReplaceChild("wingsfront", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)17.0f, (float)-2.0f));
        wingsfront.addOrReplaceChild("left", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -2.0f, 12.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        wingsfront.addOrReplaceChild("right", CubeListBuilder.create().texOffs(0, 4).addBox(-12.0f, 0.0f, -2.0f, 12.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition wingsback = partdefinition.addOrReplaceChild("wingsback", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)2.0f));
        wingsback.addOrReplaceChild("right2", CubeListBuilder.create().texOffs(0, 19).addBox(-9.0f, 0.0f, -2.0f, 9.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        wingsback.addOrReplaceChild("left2", CubeListBuilder.create().texOffs(19, 16).addBox(0.0f, 0.0f, -2.0f, 9.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Venomite entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float move;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        float a = 1.0f;
        if (ageInTicks % 10.0f >= 5.0f) {
            a = -1.0f;
        }
        this.rightFront.zRot = move = Mth.lerp((float)(ageInTicks % 5.0f / 5.0f), (float)-1.0f, (float)1.0f) * a;
        this.leftFront.zRot = -move;
        this.rightBack.zRot = -move;
        this.leftBack.zRot = move;
        a = ageInTicks % 10.0f / 10.0f;
        this.tail.xRot = ageInTicks % 20.0f >= 10.0f ? Mth.lerp((float)a, (float)-0.1f, (float)0.25f) : Mth.lerp((float)a, (float)0.25f, (float)-0.1f);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.wingsfront.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.wingsback.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

