/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.google.common.collect.ImmutableList;
import io.github.razordevs.deep_aether.entity.living.quail.Quail;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class QuailModel
extends AgeableListModel<Quail> {
    private final ModelPart head;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart body;

    public QuailModel(ModelPart root) {
        this.head = root.getChild("head");
        this.leftWing = root.getChild("left_wing");
        this.rightWing = root.getChild("right_wing");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.body = root.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 14).addBox(-2.0f, -7.0f, -4.0f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(13, 14).addBox(-2.0f, -5.0f, -5.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.0f, (float)-4.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(6, 20).mirror().addBox(0.0f, -2.0f, -1.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)1.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(6, 20).addBox(0.0f, -2.0f, -1.0f, 0.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-6.0f, (float)1.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        head.addOrReplaceChild("head_r3", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -13.0f, -2.5f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(12, 17).addBox(-0.49f, -0.5f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.5f, (float)13.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(12, 17).addBox(-0.51f, -0.5f, -3.0f, 1.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)13.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(20, 14).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)19.0f, (float)1.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(20, 14).addBox(-1.0f, 0.0f, -3.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)19.0f, (float)1.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(0, 20).mirror().addBox(0.0f, -3.0f, -1.0f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-9.0f, (float)4.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        body.addOrReplaceChild("body_r2", CubeListBuilder.create().texOffs(0, 20).addBox(0.0f, -3.0f, -1.0f, 0.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-9.0f, (float)4.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        body.addOrReplaceChild("body_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, 5.0f, 6.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(Quail entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightWing.zRot = ageInTicks;
        this.leftWing.zRot = -ageInTicks;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.body);
    }
}

