/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.natural;

import io.github.razordevs.deep_aether.init.DAItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VirulentQuicksandBlock
extends PowderSnowBlock {
    public VirulentQuicksandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState state, boolean b) {
        level.scheduleTick(blockPos, (Block)this, this.getDelayAfterPlace());
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        levelAccessor.scheduleTick(blockPos, (Block)this, this.getDelayAfterPlace());
        return super.updateShape(blockState, direction, blockState1, levelAccessor, blockPos, blockPos1);
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public static boolean isFree(BlockState blockState) {
        return blockState.isAir() || blockState.is(BlockTags.FIRE) || !blockState.getFluidState().isEmpty() || blockState.canBeReplaced();
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        BlockPos blockpos;
        if (randomSource.nextInt(16) == 0 && VirulentQuicksandBlock.isFree(level.getBlockState(blockpos = blockPos.below()))) {
            double d0 = (double)blockPos.getX() + randomSource.nextDouble();
            double d1 = (double)blockPos.getY() - 0.05;
            double d2 = (double)blockPos.getZ() + randomSource.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.WHITE_ASH, d0, d1, d2, 0.1, 0.0, 0.2);
            level.addParticle((ParticleOptions)ParticleTypes.WHITE_ASH, d0, d1, d2, 0.2, 0.0, 0.1);
        }
    }

    public void entityInside(BlockState blockState, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity) || entity.getInBlockState().is((Block)this)) {
            entity.makeStuckInBlock(blockState, new Vec3((double)0.9f, 1.5, (double)0.9f));
            if (level.isClientSide) {
                boolean flag;
                RandomSource randomsource = level.getRandom();
                boolean bl = flag = entity.xOld != entity.getX() || entity.zOld != entity.getZ();
                if (flag && randomsource.nextBoolean()) {
                    level.addParticle((ParticleOptions)ParticleTypes.ASH, entity.getX(), (double)(pos.getY() + 1), entity.getZ(), (double)(Mth.randomBetween((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f), (double)0.05f, (double)(Mth.randomBetween((RandomSource)randomsource, (float)-1.0f, (float)1.0f) * 0.083333336f));
                }
            }
        }
        if ((int)entity.getEyeY() == pos.getY() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.hurt(level.damageSources().inWall(), 1.0f);
        }
    }

    public ItemStack pickupBlock(Player player, LevelAccessor accessor, BlockPos pos, BlockState blockState) {
        accessor.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!accessor.isClientSide()) {
            accessor.levelEvent(2001, pos, Block.getId((BlockState)blockState));
        }
        return new ItemStack((ItemLike)DAItems.VIRULENT_QUICKSAND_BUCKET.get());
    }

    public boolean skipRendering(BlockState blockState, BlockState blockState1, Direction direction) {
        return blockState1.is((Block)this) || super.skipRendering(blockState, blockState1, direction);
    }

    public VoxelShape getOcclusionShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return Shapes.empty();
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.SAND_BREAK);
    }
}

