/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.natural;

import io.github.razordevs.deep_aether.init.DABlocks;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.registries.DeferredBlock;

public class SquashStemBlock
extends StemBlock {
    private final ResourceKey<Block> attachedStem;

    public SquashStemBlock(ResourceKey<Block> fruit, ResourceKey<Block> stem, ResourceKey<Item> seed, BlockBehaviour.Properties properties) {
        super(fruit, stem, seed, properties);
        this.attachedStem = stem;
    }

    public void randomTick(BlockState blockState, ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        float f;
        if (!level.isAreaLoaded(blockPos, 1)) {
            return;
        }
        if (level.getRawBrightness(blockPos, 0) >= 9 && CommonHooks.canCropGrow((Level)level, (BlockPos)blockPos, (BlockState)blockState, (randomSource.nextInt((int)(25.0f / (f = SquashStemBlock.getGrowthSpeed(blockState, (BlockGetter)level, blockPos))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)blockState.getValue((Property)AGE);
            if (i < 7) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(randomSource);
                BlockPos blockpos = blockPos.relative(direction);
                BlockState blockstate = level.getBlockState(blockpos.below());
                Registry registry = level.registryAccess().registryOrThrow(Registries.BLOCK);
                Optional optional = registry.getOptional(this.randomizedSquash().getKey());
                Optional optional1 = registry.getOptional(this.attachedStem);
                if (optional.isPresent() && optional1.isPresent() && level.isEmptyBlock(blockpos) && (blockstate.canSustainPlant((BlockGetter)level, blockpos.below(), Direction.UP, ((Block)optional.get()).defaultBlockState()).isDefault() || blockstate.is(Blocks.FARMLAND) || blockstate.is(BlockTags.DIRT))) {
                    level.setBlockAndUpdate(blockpos, ((Block)optional.get()).defaultBlockState());
                    level.setBlockAndUpdate(blockPos, (BlockState)((Block)optional1.get()).defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)direction));
                }
            }
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    protected static float getGrowthSpeed(BlockState blockState, BlockGetter getter, BlockPos pos) {
        boolean flag1;
        Block p_52273_ = blockState.getBlock();
        float f = 1.0f;
        BlockPos blockpos = pos.below();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = getter.getBlockState(blockpos.offset(i, 0, j));
                TriState soilDecision = blockstate.canSustainPlant(getter, blockpos.offset(i, 0, j), Direction.UP, blockState);
                if (soilDecision.isDefault() ? blockstate.getBlock() instanceof FarmBlock : soilDecision.isTrue()) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(getter, pos.offset(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.north();
        BlockPos blockpos2 = pos.south();
        BlockPos blockpos3 = pos.west();
        BlockPos blockpos4 = pos.east();
        boolean flag = getter.getBlockState(blockpos3).is(p_52273_) || getter.getBlockState(blockpos4).is(p_52273_);
        boolean bl = flag1 = getter.getBlockState(blockpos1).is(p_52273_) || getter.getBlockState(blockpos2).is(p_52273_);
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = getter.getBlockState(blockpos3.north()).is(p_52273_) || getter.getBlockState(blockpos4.north()).is(p_52273_) || getter.getBlockState(blockpos4.south()).is(p_52273_) || getter.getBlockState(blockpos3.south()).is(p_52273_);
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    private DeferredBlock<Block> randomizedSquash() {
        return new Random().nextBoolean() ? DABlocks.BLUE_SQUASH : DABlocks.GREEN_SQUASH;
    }
}

