/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.natural;

import com.aetherteam.aether.block.natural.AetherGrassBlock;
import io.github.razordevs.deep_aether.datagen.registry.DAPlacedFeatures;
import io.github.razordevs.deep_aether.init.DABlocks;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;

public class GoldenGrassBlock
extends AetherGrassBlock {
    public GoldenGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = ((Block)DABlocks.MEDIUM_GOLDEN_GRASS.get()).defaultBlockState();
        Optional optional = level.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getHolder(DAPlacedFeatures.GOLDEN_GRASS_BONEMEAL);
        block0: for (int i = 0; i < 128; ++i) {
            Holder holder;
            BlockPos blockpos1 = blockpos;
            for (int j = 0; j < i / 16; ++j) {
                if (!level.getBlockState((blockpos1 = blockpos1.offset(random.nextInt(3) - 1, (random.nextInt(3) - 1) * random.nextInt(3) / 2, random.nextInt(3) - 1)).below()).is((Block)this) || level.getBlockState(blockpos1).isCollisionShapeFullBlock((BlockGetter)level, blockpos1)) continue block0;
            }
            BlockState blockstate1 = level.getBlockState(blockpos1);
            if (blockstate1.is(blockstate.getBlock()) && random.nextInt(10) == 0) {
                ((BonemealableBlock)blockstate.getBlock()).performBonemeal(level, random, blockpos1, blockstate1);
            }
            if (!blockstate1.isAir()) continue;
            if (random.nextInt(8) == 0) {
                List list = ((Biome)level.getBiome(blockpos1).value()).getGenerationSettings().getFlowerFeatures();
                if (list.isEmpty()) continue;
                holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.getFirst()).config()).feature();
            } else {
                if (optional.isEmpty()) continue;
                holder = (Holder)optional.get();
            }
            ((PlacedFeature)holder.value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, blockpos1);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        Block block;
        if (context.getItemInHand().getItem() instanceof ShovelItem) {
            return ((Block)DABlocks.GOLDEN_DIRT_PATH.get()).defaultBlockState();
        }
        if (ItemAbilities.HOE_TILL == itemAbility && (block = state.getBlock()) == this && context.getLevel().getBlockState(context.getClickedPos().above()).isAir()) {
            return Blocks.FARMLAND.defaultBlockState();
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }
}

