/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.natural;

import com.aetherteam.aether.block.AetherBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;

public class AercloudGrassBlock
extends GrassBlock {
    public AercloudGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!AercloudGrassBlock.canBeGrass(pState, (LevelReader)pLevel, pPos)) {
            if (!pLevel.isAreaLoaded(pPos, 1)) {
                return;
            }
            pLevel.setBlockAndUpdate(pPos, ((Block)AetherBlocks.COLD_AERCLOUD.get()).defaultBlockState());
        } else {
            if (!pLevel.isAreaLoaded(pPos, 3)) {
                return;
            }
            if (pLevel.getMaxLocalRawBrightness(pPos.above()) >= 9) {
                BlockState blockstate = this.defaultBlockState();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pPos.offset(pRandom.nextInt(3) - 1, pRandom.nextInt(5) - 3, pRandom.nextInt(3) - 1);
                    if (!pLevel.getBlockState(blockpos).is(Blocks.DIRT) || !AercloudGrassBlock.canPropagate(blockstate, (LevelReader)pLevel, blockpos)) continue;
                    pLevel.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(pLevel.getBlockState(blockpos.above()).is(Blocks.SNOW))));
                }
            }
        }
    }

    private static boolean canPropagate(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        return AercloudGrassBlock.canBeGrass(pState, pLevel, pPos) && !pLevel.getFluidState(blockpos).is(FluidTags.WATER);
    }

    private static boolean canBeGrass(BlockState pState, LevelReader pLevelReader, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        BlockState blockstate = pLevelReader.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && (Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)pLevelReader, (BlockState)pState, (BlockPos)pPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)pLevelReader, blockpos));
        return i < pLevelReader.getMaxLightLevel();
    }
}

