/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.spongepowered.asm.mixin.MixinEnvironment;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.network.DebugPacket;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.I18nUtils;

public class DebugPayload
extends DebugPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<DebugPayload> ID = new CustomPacketPayload.Type(Pehkui.DEBUG_PACKET);
    public static final StreamCodec<FriendlyByteBuf, DebugPayload> CODEC = DebugPayload.codec(ID);

    public DebugPayload(DebugCommand.PacketType type) {
        super(type);
    }

    public DebugPayload(FriendlyByteBuf buf) {
        super(buf);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    private static StreamCodec<FriendlyByteBuf, DebugPayload> codec(CustomPacketPayload.Type<DebugPayload> id) {
        return CustomPacketPayload.codec(DebugPacket::write, DebugPayload::new);
    }

    public static void handle(DebugPayload msg, IPayloadContext ctx) {
        DebugCommand.PacketType type = msg.type;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Minecraft client = Minecraft.getInstance();
            switch (type) {
                case MIXIN_AUDIT: {
                    client.player.displayClientMessage(I18nUtils.translate("commands.pehkui.debug.audit.start.client", "Starting Mixin environment audit (client)..."), false);
                    MixinEnvironment.getCurrentEnvironment().audit();
                    client.player.displayClientMessage(I18nUtils.translate("commands.pehkui.debug.audit.end.client", "Mixin environment audit (client) complete!"), false);
                    break;
                }
                case GARBAGE_COLLECT: {
                    System.gc();
                    break;
                }
            }
        }
    }
}

