/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"})
    private void pehkui$dropItem(ItemStack stack, boolean spread, boolean thrown, CallbackInfoReturnable<ItemEntity> info) {
        ItemEntity entity = (ItemEntity)info.getReturnValue();
        if (entity != null) {
            ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
            float scale = ScaleUtils.getEyeHeightScale((Entity)this);
            if (scale != 1.0f) {
                Vec3 pos = entity.position();
                entity.setPos(pos.x, pos.y + (double)(1.0f - scale) * 0.3, pos.z);
            }
        }
    }

    @WrapOperation(method={"aiStep()V"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/world/phys/AABB;inflate(DDD)Lnet/minecraft/world/phys/AABB;")})
    private AABB pehkui$tickMovement$expand(AABB obj, double x, double y, double z, Operation<AABB> original) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)this);
        if (widthScale != 1.0f) {
            x *= (double)widthScale;
            z *= (double)widthScale;
        }
        if (heightScale != 1.0f) {
            y *= (double)heightScale;
        }
        return (AABB)original.call(new Object[]{obj, x, y, z});
    }

    @ModifyExpressionValue(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="CONSTANT", args={"floatValue=0.5F"}, ordinal=1), @At(value="CONSTANT", args={"floatValue=0.5F"}, ordinal=2), @At(value="CONSTANT", args={"floatValue=0.5F"}, ordinal=3)})
    private float pehkui$attack$knockback(float value) {
        float scale = ScaleUtils.getKnockbackScale((Entity)this);
        return scale != 1.0f ? scale * value : value;
    }

    @ModifyExpressionValue(method={"getCurrentItemAttackStrengthDelay()F"}, at={@At(value="CONSTANT", args={"doubleValue=20.0D"})})
    private double pehkui$getAttackCooldownProgressPerTick$multiplier(double value) {
        float scale = ScaleUtils.getAttackSpeedScale((Entity)this);
        return scale != 1.0f ? value / (double)scale : value;
    }

    @Inject(at={@At(value="RETURN")}, method={"getDigSpeed(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/BlockPos;)F"}, cancellable=true)
    private void pehkui$getBlockBreakingSpeed(BlockState block, BlockPos pos, CallbackInfoReturnable<Float> info) {
        float scale = ScaleUtils.getMiningSpeedScale((Entity)this);
        if (scale != 1.0f) {
            info.setReturnValue((Object)Float.valueOf(info.getReturnValueF() * scale));
        }
    }

    @ModifyExpressionValue(method={"moveCloak()V"}, at={@At(value="CONSTANT", args={"doubleValue=10.0D"}), @At(value="CONSTANT", args={"doubleValue=-10.0D"})})
    private double pehkui$updateCapeAngles$limits(double value) {
        float scale = ScaleUtils.getMotionScale((Entity)this);
        return scale != 1.0f ? (double)scale * value : value;
    }
}

