/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.util.ModLoaderUtils;
import virtuoel.pehkui.util.VersionUtils;

public class PehkuiMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE = "virtuoel.pehkui.mixin";
    @ApiStatus.Experimental
    private static final boolean DISABLE_THREAD_SAFETY = Boolean.parseBoolean(System.getProperty("pehkui.disableThreadSafety"));
    private static final boolean REACH_ATTRIBUTES_LOADED = ModLoaderUtils.isModLoaded("reach-entity-attributes");
    private static final boolean STEP_HEIGHT_ATTRIBUTES_LOADED = ModLoaderUtils.isModLoaded("step-height-entity-attribute");
    private static final boolean IDENTITY_LOADED = ModLoaderUtils.isModLoaded("identity");
    private static final boolean MAGNA_LOADED = ModLoaderUtils.isModLoaded("magna");
    private static final boolean OPTIFABRIC_LOADED = ModLoaderUtils.isModLoaded("optifabric");
    public static final boolean APOTHIC_ATTRIBUTES_LOADED = ModLoaderUtils.isModLoaded("attributeslib");

    public void onLoad(String mixinPackage) {
        if (!mixinPackage.startsWith(MIXIN_PACKAGE)) {
            throw new IllegalArgumentException(String.format("Invalid package: Expected \"%s\", but found \"%s\".", MIXIN_PACKAGE, mixinPackage));
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(MIXIN_PACKAGE)) {
            throw new IllegalArgumentException(String.format("Invalid package for class \"%s\": Expected \"%s\", but found \"%s\".", targetClassName, MIXIN_PACKAGE, mixinClassName));
        }
        if (!VersionUtils.shouldApplyCompatibilityMixin(mixinClassName)) {
            return false;
        }
        if (mixinClassName.endsWith("InGameOverlayRendererMixin")) {
            return OPTIFABRIC_LOADED == mixinClassName.contains(".optifine.compat.");
        }
        if (mixinClassName.endsWith("IForgeEntityMixin")) {
            return true;
        }
        if (mixinClassName.endsWith("IForgePlayerMixin")) {
            return true;
        }
        if (mixinClassName.equals("virtuoel.pehkui.mixin.reach.client.compat1204minus.ClientPlayerInteractionManagerMixin") || mixinClassName.equals("virtuoel.pehkui.mixin.reach.client.compat1204minus.GameRendererMixin")) {
            return false;
        }
        if (mixinClassName.endsWith("ThreadSafeScaledEntityMixin")) {
            return !DISABLE_THREAD_SAFETY;
        }
        if (mixinClassName.endsWith("ThreadUnsafeScaledEntityMixin")) {
            if (DISABLE_THREAD_SAFETY) {
                Pehkui.LOGGER.warn("Found property -Dpehkui.disableThreadSafety=true. The synchronized() blocks in scale getters have been disabled.", new Object[0]);
            }
            return DISABLE_THREAD_SAFETY;
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.reach")) {
            return REACH_ATTRIBUTES_LOADED == mixinClassName.contains(".reach.compat.");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.step_height")) {
            return STEP_HEIGHT_ATTRIBUTES_LOADED == mixinClassName.contains("virtuoel.pehkui.mixin.step_height.compat.");
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.identity.compat")) {
            return IDENTITY_LOADED;
        }
        if (mixinClassName.startsWith("virtuoel.pehkui.mixin.magna.compat")) {
            return MAGNA_LOADED;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

