/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={HangingEntity.class})
public abstract class AbstractDecorationEntityMixin {
    @ModifyVariable(method={"spawnAtLocation(Lnet/minecraft/world/item/ItemStack;F)Lnet/minecraft/world/entity/item/ItemEntity;"}, at=@At(value="STORE"))
    private ItemEntity pehkui$dropStack(ItemEntity entity) {
        ScaleUtils.setScaleOfDrop((Entity)entity, (Entity)this);
        return entity;
    }

    @ModifyArg(method={"recalculateBoundingBox()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/decoration/HangingEntity;setBoundingBox(Lnet/minecraft/world/phys/AABB;)V"))
    private AABB pehkui$updateAttachmentPosition$setBoundingBox(AABB box) {
        HangingEntity entity = (HangingEntity)this;
        Direction facing = entity.getDirection();
        double xLength = box.getXsize() / -2.0;
        double yLength = box.getYsize() / -2.0;
        double zLength = box.getZsize() / -2.0;
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((Entity)entity);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((Entity)entity);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            double dX = xLength * (1.0 - (double)widthScale);
            double dY = yLength * (1.0 - (double)heightScale);
            double dZ = zLength * (1.0 - (double)widthScale);
            box = box.inflate(dX, dY, dZ);
            box = box.move(dX * (double)facing.getStepX(), dY * (double)facing.getStepY(), dZ * (double)facing.getStepZ());
        }
        return box;
    }
}

