/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.mixin.EntitySelectorOptionsInvoker;
import virtuoel.pehkui.util.CommandUtils;
import virtuoel.pehkui.util.I18nUtils;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.PehkuiEntitySelectorReaderExtensions;
import virtuoel.pehkui.util.ReflectionUtils;

public class PehkuiEntitySelectorOptions {
    public static final Component SCALE_RANGE_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_range.description", "Entities with scale value");
    public static final Component SCALE_TYPE_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_type.description", "Entities with scale type");
    public static final Component SCALE_NBT_DESCRIPTION = I18nUtils.translate("argument.entity.options.pehkui.scale_nbt.description", "Entities with scale NBT");

    public static void register() {
        EntitySelectorOptionsInvoker.callRegister(Pehkui.id("scale").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setScaleRange(MinMaxBounds.Doubles.fromReader((StringReader)r.getReader())), r -> ReflectionUtils.isDummy(PehkuiEntitySelectorOptions.cast(r).pehkui_getScaleRange()), SCALE_RANGE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callRegister(Pehkui.id("scale_type").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setScaleType(PehkuiEntitySelectorOptions.parseScaleType(r)), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getScaleType() == ScaleTypes.INVALID, SCALE_TYPE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callRegister(Pehkui.id("computed_scale").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setComputedScaleRange(MinMaxBounds.Doubles.fromReader((StringReader)r.getReader())), r -> ReflectionUtils.isDummy(PehkuiEntitySelectorOptions.cast(r).pehkui_getComputedScaleRange()), SCALE_RANGE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callRegister(Pehkui.id("computed_scale_type").toString().replace(':', '.'), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_setComputedScaleType(PehkuiEntitySelectorOptions.parseScaleType(r)), r -> PehkuiEntitySelectorOptions.cast(r).pehkui_getComputedScaleType() == ScaleTypes.INVALID, SCALE_TYPE_DESCRIPTION);
        EntitySelectorOptionsInvoker.callRegister(Pehkui.id("scale_nbt").toString().replace(':', '.'), r -> {
            boolean negated = r.shouldInvertValue();
            CompoundTag parsed = new TagParser(r.getReader()).readStruct();
            r.addPredicate(entity -> {
                CompoundTag nbt = ((PehkuiEntityExtensions)entity).pehkui_writeScaleNbt(new CompoundTag());
                return NbtUtils.compareNbt((Tag)parsed, (Tag)nbt, (boolean)true) != negated;
            });
        }, reader -> true, SCALE_NBT_DESCRIPTION);
    }

    private static PehkuiEntitySelectorReaderExtensions cast(EntitySelectorParser reader) {
        return (PehkuiEntitySelectorReaderExtensions)reader;
    }

    private static ScaleType parseScaleType(EntitySelectorParser reader) throws CommandSyntaxException {
        reader.setSuggestions((builder, consumer) -> {
            CommandUtils.suggestIdentifiersIgnoringNamespace("pehkui", ScaleRegistries.SCALE_TYPES.keySet(), builder);
            return builder.buildFuture();
        });
        int i = reader.getReader().getCursor();
        ResourceLocation id = ResourceLocation.read((StringReader)reader.getReader());
        ScaleType scaleType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, id);
        ResourceLocation defaultId = ScaleRegistries.getDefaultId(ScaleRegistries.SCALE_TYPES);
        ScaleType defaultType = ScaleRegistries.getEntry(ScaleRegistries.SCALE_TYPES, defaultId);
        if (scaleType == null || scaleType == defaultType && !id.equals((Object)defaultId)) {
            reader.getReader().setCursor(i);
            throw ScaleTypeArgumentType.INVALID_ENTRY_EXCEPTION.createWithContext((ImmutableStringReader)reader.getReader(), (Object)id.toString());
        }
        return scaleType;
    }
}

