/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.ToDoubleBiFunction;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleEasings;
import virtuoel.pehkui.api.ScaleEventCallback;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ReflectionUtils;

public class ScaleType {
    private boolean affectsDimensions;
    private boolean defaultPersistence;
    private Float2FloatFunction defaultEasing;
    private float defaultBaseScale;
    private int defaultTickDelay;
    private final ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction;
    private final ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction;
    private final Set<ScaleModifier> defaultBaseValueModifiers;
    private final Collection<ScaleEventCallback> scaleChangedEvent = new ArrayList<ScaleEventCallback>();
    private final Collection<ScaleEventCallback> preTickEvent = new ArrayList<ScaleEventCallback>();
    private final Collection<ScaleEventCallback> postTickEvent = new ArrayList<ScaleEventCallback>();

    private ScaleType(Builder builder) {
        this.defaultBaseScale = builder.defaultBaseScale;
        this.defaultTickDelay = builder.defaultTickDelay;
        this.defaultBaseValueModifiers = builder.defaultBaseValueModifiers;
        this.baseScaleClampFunction = builder.baseScaleClampFunction;
        this.targetScaleClampFunction = builder.targetScaleClampFunction;
        this.defaultPersistence = builder.defaultPersistence;
        this.defaultEasing = builder.defaultEasing;
        this.affectsDimensions = builder.affectsDimensions;
    }

    public ScaleData getScaleData(Entity entity) {
        return ((PehkuiEntityExtensions)entity).pehkui_getScaleData(this);
    }

    @ApiStatus.Internal
    public boolean getAffectsDimensions() {
        return this.affectsDimensions;
    }

    public void setDefaultPersistence(boolean persistent) {
        this.defaultPersistence = persistent;
    }

    public boolean getDefaultPersistence() {
        return this.defaultPersistence;
    }

    public void setDefaultEasing(Float2FloatFunction defaultEasing) {
        this.defaultEasing = defaultEasing;
    }

    public Float2FloatFunction getDefaultEasing() {
        return this.defaultEasing;
    }

    public final float getDefaultBaseScale() {
        return this.defaultBaseScale;
    }

    public final int getDefaultTickDelay() {
        return this.defaultTickDelay;
    }

    public double clampBaseScale(ScaleData data, double newScale) {
        return this.baseScaleClampFunction.applyAsDouble(data, newScale);
    }

    public double clampTargetScale(ScaleData data, double newScale) {
        return this.targetScaleClampFunction.applyAsDouble(data, newScale);
    }

    public Set<ScaleModifier> getDefaultBaseValueModifiers() {
        return this.defaultBaseValueModifiers;
    }

    public Collection<ScaleEventCallback> getScaleChangedEvent() {
        return this.scaleChangedEvent;
    }

    public Collection<ScaleEventCallback> getPreTickEvent() {
        return this.preTickEvent;
    }

    public Collection<ScaleEventCallback> getPostTickEvent() {
        return this.postTickEvent;
    }

    public static class Builder {
        private Set<ScaleModifier> defaultBaseValueModifiers = new ObjectRBTreeSet();
        private float defaultBaseScale = 1.0f;
        private int defaultTickDelay = 20;
        private float defaultMinPositiveScale = 1.2621775E-29f;
        private float defaultMaxPositiveScale = 4.2949673E9f;
        private ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction = (scaleData, newScale) -> {
            if (newScale > (double)this.defaultMaxPositiveScale) {
                return this.defaultMaxPositiveScale;
            }
            if (newScale < (double)(-this.defaultMaxPositiveScale)) {
                return -this.defaultMaxPositiveScale;
            }
            if (newScale > (double)this.defaultMinPositiveScale || newScale < (double)(-this.defaultMinPositiveScale)) {
                return newScale;
            }
            return scaleData.getTargetScale() < 0.0f ? (double)(-this.defaultMinPositiveScale) : (double)this.defaultMinPositiveScale;
        };
        private ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction = (scaleData, newScale) -> {
            if (newScale > (double)this.defaultMaxPositiveScale) {
                return this.defaultMaxPositiveScale;
            }
            if (newScale < (double)(-this.defaultMaxPositiveScale)) {
                return -this.defaultMaxPositiveScale;
            }
            if (newScale > (double)this.defaultMinPositiveScale || newScale < (double)(-this.defaultMinPositiveScale)) {
                return newScale;
            }
            return newScale < 0.0 ? (double)(-this.defaultMinPositiveScale) : (double)this.defaultMinPositiveScale;
        };
        private boolean affectsDimensions = false;
        private Set<ScaleModifier> dependentModifiers = new ObjectRBTreeSet();
        private boolean defaultPersistence = false;
        private Float2FloatFunction defaultEasing = ScaleEasings.LINEAR;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder defaultBaseScale(float defaultBaseScale) {
            this.defaultBaseScale = defaultBaseScale;
            return this;
        }

        public Builder defaultTickDelay(int defaultTickDelay) {
            this.defaultTickDelay = defaultTickDelay;
            return this;
        }

        public Builder defaultMinPositiveScale(float defaultMinPositiveScale) {
            this.defaultMinPositiveScale = defaultMinPositiveScale;
            return this;
        }

        public Builder defaultMaxPositiveScale(float defaultMaxPositiveScale) {
            this.defaultMaxPositiveScale = defaultMaxPositiveScale;
            return this;
        }

        public Builder clampedBaseScale(ToDoubleBiFunction<ScaleData, Double> baseScaleClampFunction) {
            this.baseScaleClampFunction = baseScaleClampFunction;
            return this;
        }

        public Builder clampedTargetScale(ToDoubleBiFunction<ScaleData, Double> targetScaleClampFunction) {
            this.targetScaleClampFunction = targetScaleClampFunction;
            return this;
        }

        public Builder addBaseValueModifier(ScaleModifier scaleModifier) {
            this.defaultBaseValueModifiers.add(scaleModifier);
            return this;
        }

        public Builder defaultPersistence(boolean defaultPersistence) {
            this.defaultPersistence = defaultPersistence;
            return this;
        }

        public Builder defaultEasing(Float2FloatFunction defaultEasing) {
            this.defaultEasing = defaultEasing;
            return this;
        }

        public Builder affectsDimensions() {
            this.affectsDimensions = true;
            return this;
        }

        public Builder addDependentModifier(ScaleModifier scaleModifier) {
            this.dependentModifiers.add(scaleModifier);
            return this;
        }

        public ScaleType build() {
            ScaleType type = new ScaleType(this);
            if (this.affectsDimensions || !this.dependentModifiers.isEmpty()) {
                type.getScaleChangedEvent().add(Builder.createScaleChangedEvent(this.dependentModifiers));
            }
            return type;
        }

        private static ScaleEventCallback createScaleChangedEvent(Collection<ScaleModifier> modifiers) {
            return s -> {
                Entity e = s.getEntity();
                if (e != null) {
                    boolean recalculateDimensions = s.getScaleType().getAffectsDimensions();
                    if (!modifiers.isEmpty()) {
                        for (ScaleType scaleType : ScaleRegistries.SCALE_TYPES.values()) {
                            ScaleData data = scaleType.getScaleData(e);
                            if (Collections.disjoint(modifiers, data.getBaseValueModifiers())) continue;
                            data.invalidateCachedScales();
                            data.markForSync(true);
                            recalculateDimensions |= scaleType.getAffectsDimensions();
                        }
                    }
                    if (recalculateDimensions) {
                        PehkuiEntityExtensions en = (PehkuiEntityExtensions)e;
                        boolean onGround = en.pehkui_getOnGround();
                        e.refreshDimensions();
                        ReflectionUtils.setOnGround(e, onGround);
                    }
                }
            };
        }
    }
}

