/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.kube;

import com.almostreliable.unified.api.AlmostUnified;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.UnificationEntry;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class AlmostKube {
    private AlmostKube() {
    }

    private static AlmostUnifiedRuntime getRuntime() {
        return AlmostUnified.INSTANCE.getRuntimeOrThrow();
    }

    public static Set<String> getTags() {
        return AlmostKube.getRuntime().getUnificationLookup().getTags().stream().map(tag -> tag.location().toString()).collect(Collectors.toSet());
    }

    public static Set<String> getTagEntries(ResourceLocation tag) {
        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag);
        return AlmostKube.getRuntime().getUnificationLookup().getTagEntries((TagKey<Item>)tagKey).stream().map(holder -> holder.id().toString()).collect(Collectors.toSet());
    }

    @Nullable
    public static String getRelevantItemTag(ItemStack stack) {
        TagKey<Item> tag = AlmostKube.getRuntime().getUnificationLookup().getRelevantItemTag(AlmostKube.getId(stack));
        return tag == null ? null : tag.location().toString();
    }

    public static ItemStack getVariantItemTarget(ItemStack stack) {
        UnificationEntry<Item> entry = AlmostKube.getRuntime().getUnificationLookup().getVariantItemTarget(AlmostKube.getId(stack));
        if (entry == null) {
            return ItemStack.EMPTY;
        }
        return entry.value().getDefaultInstance();
    }

    public static ItemStack getTagTargetItem(ResourceLocation tag) {
        TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag);
        UnificationEntry<Item> entry = AlmostKube.getRuntime().getUnificationLookup().getTagTargetItem((TagKey<Item>)tagKey);
        if (entry == null) {
            return ItemStack.EMPTY;
        }
        return entry.value().getDefaultInstance();
    }

    private static ResourceLocation getId(ItemStack stack) {
        return BuiltInRegistries.ITEM.getResourceKey((Object)stack.getItem()).map(ResourceKey::location).orElseThrow(() -> new IllegalArgumentException("Item not found in registry"));
    }
}

