/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.core.data.recipes;

import com.soytutta.mynethersdelight.common.registry.MNDBlocks;
import com.soytutta.mynethersdelight.common.registry.MNDItems;
import com.soytutta.mynethersdelight.common.tag.MNDTags;
import com.soytutta.mynethersdelight.common.tag.MyCommonTags;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.DifferenceIngredient;
import vectorwing.farmersdelight.common.crafting.FoodServingRecipe;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.tag.CommonTags;

public class MNDCraftingRecipes {
    public static void register(RecipeOutput output) {
        MNDCraftingRecipes.recipesVanillaAlternatives(output);
        MNDCraftingRecipes.recipesBlocks(output);
        MNDCraftingRecipes.recipesCraftedMeals(output);
        SpecialRecipeBuilder.special(FoodServingRecipe::new).save(output, "food_serving");
    }

    private static void recipesVanillaAlternatives(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SUGAR).requires((ItemLike)MNDItems.STRIDER_EGG.get()).unlockedBy("has_sugar", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.SUGAR, (ItemLike)MNDItems.STRIDER_EGG.get()})).save(output, "mynethersdelight:crafting/sugar_alt");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLAZE_POWDER, (int)2).requires((ItemLike)Items.BLAZE_POWDER).requires((ItemLike)MNDItems.PEPPER_POWDER.get(), 3).unlockedBy("has_blaze_powder", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER, (ItemLike)MNDItems.PEPPER_POWDER.get()})).save(output, "mynethersdelight:crafting/blaze_powder_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.STICK).pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO, (ItemLike)MNDItems.POWDER_CANNON.get()})).unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()})).save(output, "mynethersdelight:crafting/stick_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.TNT).pattern("#s#").pattern("s#s").pattern("#s#").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDER_CANNON.get()).define(Character.valueOf('s'), ItemTags.SAND).unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()})).save(output, "mynethersdelight:crafting/tnt_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SCAFFOLDING, (int)6).pattern("B#b").pattern("B b").pattern("B b").define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO, (ItemLike)MNDItems.POWDER_CANNON.get()})).define(Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get(), Items.BAMBOO})).define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CANVAS.get(), Items.STRING})).unlockedBy("has_powder_cannon_or_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get(), (ItemLike)ModItems.CANVAS.get()})).save(output, "mynethersdelight:crafting/scaffolding_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.BASKET.get())).pattern("B b").pattern("# #").pattern("b#B").define(Character.valueOf('b'), Ingredient.of((ItemLike[])new ItemLike[]{Items.BAMBOO, (ItemLike)MNDItems.POWDER_CANNON.get()})).define(Character.valueOf('B'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get(), Items.BAMBOO})).define(Character.valueOf('#'), (ItemLike)ModItems.CANVAS.get()).unlockedBy("has_powder_cannon_or_canvas", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get(), (ItemLike)ModItems.CANVAS.get()})).save(output, "mynethersdelight:crafting/basket_alt");
    }

    private static void recipesBlocks(RecipeOutput output) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.NETHER_BRICKS_CABINET.get())).unlockedBy("has_nether_bricks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NETHER_BRICKS})).save(output, "mynethersdelight:stonecutting/nether_bricks_cabinet");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.RED_NETHER_BRICKS}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.RED_NETHER_BRICKS_CABINET.get())).unlockedBy("has_nether_bricks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.NETHER_BRICKS})).save(output, "mynethersdelight:stonecutting/red_nether_bricks_cabinet");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.POLISHED_BLACKSTONE_BRICKS, Items.POLISHED_BLACKSTONE, Items.BLACKSTONE}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.BLACKSTONE_BRICKS_CABINET.get())).unlockedBy("has_blackstone", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BLACKSTONE, Items.POLISHED_BLACKSTONE, Items.POLISHED_BLACKSTONE_BRICKS})).save(output, "mynethersdelight:stonecutting/blackstone_bricks_cabinet");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.BULLET_PEPPER_CRATE.get()), (int)1).requires((ItemLike)MNDItems.BULLET_PEPPER.get(), 9).unlockedBy("has_pepper", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BULLET_PEPPER.get()})).save(output, "mynethersdelight:crafting/bullet_papper_crate");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.BULLET_PEPPER.get()), (int)9).requires((ItemLike)MNDItems.BULLET_PEPPER_CRATE.get()).unlockedBy("has_pepper", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BULLET_PEPPER.get()})).save(output, "mynethersdelight:crafting/bullet_papper_crate_alt");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.BLOCK_OF_POWDERY_CANNON.get())).pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDER_CANNON.get()).unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()})).save(output, "mynethersdelight:crafting/block_of_powdery_cannon");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDBlocks.POWDERY_CABINET.get())).pattern("XXX").pattern("T T").pattern("XXX").define(Character.valueOf('X'), (ItemLike)MNDItems.POWDERY_PLANKS_SLAB.get()).define(Character.valueOf('T'), (ItemLike)MNDItems.POWDERY_TRAPDOOR.get()).unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/block_of_powdery_cabinet");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.POWDERY_PLANKS.get()), (int)4).requires(MNDTags.BLOCK_OF_POWDERY).group("planks").unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()})).save(output, "mynethersdelight:crafting/powdery_plank");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.POWDERY_PLANKS_SLAB.get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).group("wooden_slab").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_slab");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.POWDERY_PLANKS_STAIRS.get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).group("wooden_stairs").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.POWDERY_MOSAIC.get())).pattern("#").pattern("#").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS_SLAB.get()).unlockedBy("has_powdery_mosaic", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_MOSAIC.get(), (ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_mosaic");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.POWDERY_MOSAIC_SLAB.get()), (int)6).pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_MOSAIC.get()).group("wooden_slab").unlockedBy("has_powdery_mosaic", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_MOSAIC.get(), (ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_mosaic_slab");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.POWDERY_MOSAIC_STAIRS.get()), (int)4).pattern("#  ").pattern("## ").pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_MOSAIC.get()).group("wooden_stairs").unlockedBy("has_powdery_mosaic", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_MOSAIC.get(), (ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_mosaic_stairs");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)MNDBlocks.POWDERY_DOOR.get()), (int)3).pattern("##").pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).group("wooden_door").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_door");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)MNDBlocks.POWDERY_TRAPDOOR.get()), (int)2).pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).group("wooden_trapdoor").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_trapdoor");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)MNDBlocks.POWDERY_PRESSURE_PLATE.get())).pattern("##").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).group("wooden_pressure_plate").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_pressure_plate");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)MNDItems.POWDERY_BUTTON.get())).requires((ItemLike)MNDItems.POWDERY_PLANKS.get()).group("wooden_button").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_button");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDBlocks.POWDERY_SIGN.get()), (int)3).pattern("###").pattern("###").pattern(" X ").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).define(Character.valueOf('X'), (ItemLike)Items.STICK).group("wooden_sign").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_sign");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDBlocks.POWDERY_HANGING_SIGN.get()), (int)6).pattern("X X").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)MNDItems.BLOCK_OF_STRIPPED_POWDERY_CANNON.get()).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).group("wooden_hanging_sign").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BLOCK_OF_STRIPPED_POWDERY_CANNON.get()})).save(output, "mynethersdelight:crafting/powdery_hanging_sign");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDBlocks.POWDERY_FENCE.get()), (int)3).pattern("#X#").pattern("#X#").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).define(Character.valueOf('X'), (ItemLike)Items.STICK).group("wooden_fence").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_fence");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)MNDBlocks.POWDERY_FENCE_GATE.get())).pattern("X#X").pattern("X#X").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDERY_PLANKS.get()).define(Character.valueOf('X'), (ItemLike)Items.STICK).group("wooden_fence_gate").unlockedBy("has_powdery_planks", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDERY_PLANKS.get()})).save(output, "mynethersdelight:crafting/powdery_fence_gate");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDBlocks.POWDERY_TORCH.get()), (int)2).pattern("P").pattern("#").define(Character.valueOf('#'), (ItemLike)MNDItems.POWDER_CANNON.get()).define(Character.valueOf('P'), (ItemLike)MNDItems.BULLET_PEPPER.get()).unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get()})).save(output, "mynethersdelight:crafting/powdery_torch");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.GOLDEN_TROPHY.get()), (int)2).pattern("iGi").pattern("iBi").pattern("iSi").define(Character.valueOf('G'), (ItemLike)MNDItems.GOLDEN_TROPHY.get()).define(Character.valueOf('S'), (ItemLike)MNDItems.SKOGLIN_TROPHY.get()).define(Character.valueOf('B'), (ItemLike)Blocks.GOLD_BLOCK).define(Character.valueOf('i'), (ItemLike)Items.GOLD_INGOT).group("nether_trophy").unlockedBy("has_golden_trophy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GOLDEN_TROPHY.get()})).save(output, "mynethersdelight:crafting/golden_trophy");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.HOGLIN_TROPHY.get())).pattern("W#W").pattern("bBb").pattern("WGW").define(Character.valueOf('#'), (ItemLike)MNDItems.HOGLIN_HIDE.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('B'), (ItemLike)Blocks.BONE_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.BONE).define(Character.valueOf('W'), ItemTags.PLANKS).group("nether_trophy").unlockedBy("has_hoglin_hide", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_HIDE.get()})).save(output, "mynethersdelight:crafting/hoglin_trophy");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.WAXED_HOGLIN_TROPHY.get())).requires((ItemLike)MNDItems.HOGLIN_TROPHY.get()).requires(Ingredient.of(MNDTags.HOGLIN_WAXED)).group("nether_trophy").unlockedBy("has_hoglin_trophy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_TROPHY.get()})).save(output, "mynethersdelight:crafting/waxed_hoglin_trophy");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.HOGLIN_TROPHY.get())).requires((ItemLike)MNDItems.ZOGLIN_TROPHY.get()).requires(Ingredient.of(MNDTags.HOGLIN_CURE)).group("nether_trophy").unlockedBy("has_zoglin_trophy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.ZOGLIN_TROPHY.get()})).save(output, "mynethersdelight:crafting/hoglin_trophy_cure");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDBlocks.ZOGLIN_TROPHY.get())).pattern("wZw").pattern("Z#Z").pattern("wZw").define(Character.valueOf('#'), (ItemLike)MNDItems.HOGLIN_TROPHY.get()).define(Character.valueOf('Z'), (ItemLike)Items.ROTTEN_FLESH).define(Character.valueOf('w'), (ItemLike)Items.WARPED_FUNGUS).group("nether_trophy").unlockedBy("has_hoglin_trophy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_TROPHY.get()})).save(output, "mynethersdelight:crafting/zoglin_trophy");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.HOGLIN_TROPHY.get())).requires((ItemLike)MNDItems.SKOGLIN_TROPHY.get()).requires(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_HIDE.get()})).group("nether_trophy").unlockedBy("has_skoglin_trophy", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.SKOGLIN_TROPHY.get()})).save(output, "mynethersdelight:crafting/skoglin_trophy");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.NETHER_STOVE.get())).requires((ItemLike)MNDItems.SOUL_NETHER_STOVE.get()).requires(Ingredient.of(MNDTags.STOVE_FIRE_FUEL)).group("nether_stove").unlockedBy("has_soul_stove", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.SOUL_NETHER_STOVE.get()})).save(output, "mynethersdelight:crafting/nethers_stove_alt0");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.NETHER_STOVE.get())).pattern("iii").pattern("B B").pattern("BCB").define(Character.valueOf('i'), Tags.Items.BRICKS_NETHER).define(Character.valueOf('B'), (ItemLike)Blocks.POLISHED_BLACKSTONE_BRICKS).define(Character.valueOf('C'), (ItemLike)Blocks.CAMPFIRE).group("nether_stove").unlockedBy("has_campfire", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Blocks.CAMPFIRE})).save(output, "mynethersdelight:crafting/nethers_stove");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.SOUL_NETHER_STOVE.get())).requires((ItemLike)MNDItems.NETHER_STOVE.get()).requires(Ingredient.of(MNDTags.STOVE_SOUL_FUEL)).group("soul_nether_stove").unlockedBy("has_stove", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.NETHER_STOVE.get()})).save(output, "mynethersdelight:crafting/soul_nethers_stove_alt0");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.SOUL_NETHER_STOVE.get())).pattern("iii").pattern("B B").pattern("BCB").define(Character.valueOf('i'), Tags.Items.BRICKS_NETHER).define(Character.valueOf('B'), (ItemLike)Blocks.POLISHED_BLACKSTONE_BRICKS).define(Character.valueOf('C'), (ItemLike)Blocks.SOUL_CAMPFIRE).group("soul_nether_stove").unlockedBy("has_soul_campfire", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Blocks.SOUL_CAMPFIRE})).save(output, "mynethersdelight:crafting/soul_nethers_stove");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.LETIOS_COMPOST.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_SAND, Items.SOUL_SOIL})).requires((ItemLike)Items.ROTTEN_FLESH, 2).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_ROOTS, Items.CRIMSON_ROOTS})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_ROOTS, Items.WARPED_ROOTS, (ItemLike)ModItems.STRAW.get()})).requires((ItemLike)Items.BONE_MEAL, 4).unlockedBy("has_rotten_flesh", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.ROTTEN_FLESH})).unlockedBy("has_roots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CRIMSON_ROOTS, Items.WARPED_ROOTS})).save(output, "mynethersdelight:crafting/letios_compost_from_rotten_flesh");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)MNDItems.LETIOS_COMPOST.get()), (int)1).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.SOUL_SAND, Items.SOUL_SOIL})).requires((ItemLike)Items.BONE_MEAL, 2).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_ROOTS, Items.CRIMSON_ROOTS})).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_ROOTS, Items.WARPED_ROOTS, (ItemLike)ModItems.STRAW.get()})).requires((ItemLike)Items.ROTTEN_FLESH, 4).unlockedBy("has_bone_meal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BONE_MEAL})).unlockedBy("has_roots", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.CRIMSON_ROOTS, Items.WARPED_ROOTS})).save(output, "mynethersdelight:crafting/letios_compost_from_bone_alt");
    }

    private static void recipesCraftedMeals(RecipeOutput output) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.BLEEDING_TARTAR.get())).requires((ItemLike)MNDItems.MINCED_STRIDER.get(), 2).requires(Tags.Items.EGGS).requires((ItemLike)Items.BOWL).unlockedBy("has_minced_strider", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.MINCED_STRIDER.get()})).save(output, "mynethersdelight:crafting/bleeding_tartar");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOTDOG.get())).requires((ItemLike)MNDItems.ROASTED_SAUSAGE.get()).requires(Tags.Items.FOODS_BREAD).unlockedBy("has_sausage", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_SAUSAGE.get()})).save(output, "mynethersdelight:crafting/hotdog");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOTDOG_WITH_MIXED_SALAD.get()), (int)2).requires((ItemLike)ModItems.MIXED_SALAD.get()).requires((ItemLike)MNDItems.HOTDOG.get(), 2).unlockedBy("has_hotdog", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOTDOG.get()})).save(output, "mynethersdelight:crafting/hotdog_with_mixed_salad");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOTDOG_WITH_NETHER_SALAD.get()), (int)2).requires((ItemLike)ModItems.NETHER_SALAD.get()).requires((ItemLike)MNDItems.HOTDOG.get(), 2).unlockedBy("has_hotdog", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOTDOG.get()})).save(output, "mynethersdelight:crafting/hotdog_with_nether_salad");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.STRIDERLOAF_BLOCK.get())).requires((ItemLike)MNDItems.STRIDER_SLICE.get()).requires((ItemLike)MNDItems.MINCED_STRIDER.get(), 3).requires((ItemLike)Items.BOWL).unlockedBy("has_minced_strider", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.MINCED_STRIDER.get()})).save(output, "mynethersdelight:crafting/striderloaf");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.BLUE_TENDERLOIN_STEAK.get())).requires((ItemLike)MNDItems.COOKED_LOIN.get()).requires((ItemLike)Blocks.WARPED_FUNGUS).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS, Items.WARPED_ROOTS, (ItemLike)ModItems.STRAW.get()})).requires((ItemLike)Items.BOWL).unlockedBy("has_hoglin_loin", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_LOIN.get()})).group("blue_tenderloin_steak_group").save(output, "mynethersdelight:crafting/blue_tenderloin_steak");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.NETHER_BURGER.get())).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)MNDItems.COOKED_LOIN.get()).requires((ItemLike)Items.TWISTING_VINES).requires((ItemLike)Items.CRIMSON_FUNGUS).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.WARPED_FUNGUS, Items.CRIMSON_FUNGUS})).unlockedBy("has_hoglin_loin", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_LOIN.get()})).save(output, "mynethersdelight:crafting/nether_burger");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.RED_LOIN_STICK.get())).requires((ItemLike)MNDItems.COOKED_LOIN.get()).requires((ItemLike)Blocks.CRIMSON_FUNGUS).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.CRIMSON_FUNGUS, Items.RED_MUSHROOM})).requires((ItemLike)Items.STICK).unlockedBy("has_hoglin_loin", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_LOIN.get()})).save(output, "mynethersdelight:crafting/red_loin_on_a_stick");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.BACON_WRAPPED_SAUSAGE_STICK.get())).requires((ItemLike)MNDItems.ROASTED_SAUSAGE.get()).requires((ItemLike)ModItems.COOKED_BACON.get()).requires((ItemLike)Items.STICK).unlockedBy("has_sausage", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_SAUSAGE.get()})).save(output, "mynethersdelight:crafting/bacon_wrapped_sausage_stick");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.BREAKFAST_SAMPLER.get())).requires((ItemLike)MNDItems.ROASTED_SAUSAGE.get(), 2).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.HONEY_BOTTLE, (ItemLike)MNDItems.STRIDER_EGG.get()})).requires(CommonTags.FOODS_COOKED_EGG).requires(CommonTags.FOODS_COOKED_EGG).requires(Tags.Items.FOODS_BREAD).requires((ItemLike)Items.BOWL).unlockedBy("has_sausage", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.ROASTED_SAUSAGE.get()})).save(output, "mynethersdelight:crafting/breakfast_sampler");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.GOLDEN_EGG.get())).pattern("###").pattern("#E#").pattern("###").define(Character.valueOf('E'), MyCommonTags.FOODS_BOILED_EGG).define(Character.valueOf('#'), (ItemLike)Items.GOLD_INGOT).unlockedBy("has_gold_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})).save(output, "mynethersdelight:crafting/golden_egg");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.STUFFED_PEPPER.get())).requires((ItemLike)MNDItems.BULLET_PEPPER.get()).requires(CommonTags.FOODS_COOKED_PORK).requires(CommonTags.FOODS_MILK).unlockedBy("has_pepper", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.BULLET_PEPPER.get()})).save(output, "mynethersdelight:crafting/stuffed_pepper");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOT_CREAM_CONE.get()), (int)3).requires((ItemLike)MNDItems.HOT_CREAM.get()).requires((ItemLike)MNDItems.POWDER_CANNON.get()).requires((ItemLike)MNDItems.POWDER_CANNON.get()).requires((ItemLike)MNDItems.POWDER_CANNON.get()).unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get(), (ItemLike)MNDItems.HOT_CREAM.get(), (ItemLike)MNDItems.HOT_CREAM_CONE.get()})).save(output, "mynethersdelight:crafting/hotcream_cone");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOT_CREAM.get()), (int)1).requires((ItemLike)Items.BUCKET).requires((ItemLike)MNDItems.HOT_CREAM_CONE.get()).requires((ItemLike)MNDItems.HOT_CREAM_CONE.get()).requires((ItemLike)MNDItems.HOT_CREAM_CONE.get()).unlockedBy("has_powder_cannon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.POWDER_CANNON.get(), (ItemLike)MNDItems.HOT_CREAM.get(), (ItemLike)MNDItems.HOT_CREAM_CONE.get()})).save(output, "mynethersdelight:crafting/hotcream_bucket");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)MNDItems.TEAR_POPSICLE.get()), (int)1).pattern(" ii").pattern("i#i").pattern("-i ").define(Character.valueOf('#'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('i'), (ItemLike)Items.ICE).define(Character.valueOf('-'), (ItemLike)Items.STICK).unlockedBy("has_ghast", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.GHAST_TEAR})).save(output, "mypersonaldelight:crafting/tear_popsicle");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.DRIED_GHAST_WITH_MILK.get())).requires((ItemLike)MNDItems.GHASMATI.get()).requires(CommonTags.FOODS_MILK).requires((ItemLike)Items.BOWL).unlockedBy("has_ghasmati", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASMATI.get()})).save(output, "mynethersdelight:crafting/dried_ghast_with_milk");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.SIZZLING_PUDDING.get())).requires((ItemLike)MNDItems.GHASMATI.get()).requires(CommonTags.FOODS_MILK).requires(Tags.Items.EGGS).requires(Ingredient.of((ItemLike[])new ItemLike[]{Items.BLAZE_POWDER, (ItemLike)MNDItems.PEPPER_POWDER.get()})).requires((ItemLike)Items.BOWL).unlockedBy("has_ghasmati", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASMATI.get()})).save(output, "mynethersdelight:crafting/sizzling_pudding");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.SPICY_COTTON.get())).requires((ItemLike)MNDItems.GHASTA.get()).requires(MNDTags.HOT_SPICE).requires((ItemLike)Items.BLAZE_ROD).requires((ItemLike)MNDItems.GHASTA.get()).unlockedBy("has_blaze_rod", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BLAZE_ROD, (ItemLike)MNDItems.GHASTA.get()})).save(output, "mynethersdelight:crafting/spicy_cotton");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.GHASTA_WITH_CREAM_BLOCK.get())).pattern("GGG").pattern("GT#").pattern("GBG").define(Character.valueOf('G'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASTA.get(), (ItemLike)MNDItems.GHASMATI.get()})).define(Character.valueOf('T'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('#'), (ItemLike)Items.MAGMA_CREAM).define(Character.valueOf('B'), (ItemLike)Items.BOWL).unlockedBy("has_ghast", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASMATI.get(), (ItemLike)MNDItems.GHASTA.get()})).save(output, "mynethersdelight:crafting/ghasta_with_cream");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.GHAST_DOUGH.get()), (int)2).requires(Tags.Items.EGGS).requires((ItemLike)MNDItems.GHASMATI.get(), 2).requires(Tags.Items.EGGS).unlockedBy("has_ghast", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASMATI.get(), (ItemLike)MNDItems.GHASTA.get()})).save(output, "mynethersdelight:crafting/ghast_dough");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.GHAST_SOURDOUGH.get())).requires((ItemLike)MNDItems.GHAST_DOUGH.get()).requires(CommonTags.FOODS_DOUGH).requires(CommonTags.FOODS_DOUGH).requires(CommonTags.FOODS_DOUGH).unlockedBy("has_ghast", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASMATI.get(), (ItemLike)MNDItems.GHASTA.get()})).save(output, "mynethersdelight:crafting/ghast_sourdough");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.GHAST_SALAD.get())).requires(MyCommonTags.FOODS_RAW_GHAST).requires(MNDCraftingRecipes.vegetablesPatch()).requires(Tags.Items.CROPS_CARROT).requires((ItemLike)Items.BOWL).unlockedBy("has_ghast", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.GHASMATI.get(), (ItemLike)MNDItems.GHASTA.get()})).save(output, "mynethersdelight:crafting/ghast_salad");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.SPICY_SKEWER.get())).requires((ItemLike)MNDItems.BULLET_PEPPER.get()).requires(MyCommonTags.FOODS_RAW_STRIDER).requires((ItemLike)Items.BLAZE_ROD).requires((ItemLike)MNDItems.BULLET_PEPPER.get()).unlockedBy("has_blaze_rod", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.BLAZE_ROD})).save(output, "mynethersdelight:crafting/spicy_skewer");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.RAW_STUFFED_HOGLIN.get())).pattern("hwh").pattern("l#l").pattern("hch").define(Character.valueOf('c'), (ItemLike)MNDItems.CRIMSON_FUNGUS_COLONY.get()).define(Character.valueOf('l'), (ItemLike)MNDItems.HOGLIN_LOIN.get()).define(Character.valueOf('#'), (ItemLike)MNDItems.HOGLIN_HIDE.get()).define(Character.valueOf('h'), (ItemLike)ModItems.HAM.get()).define(Character.valueOf('w'), (ItemLike)MNDItems.WARPED_FUNGUS_COLONY.get()).unlockedBy("has_hoglin_hide", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOGLIN_HIDE.get()})).save(output, "mynethersdelight:crafting/raw_stuffed_hoglin");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOT_WINGS_BUCKET.get())).requires((ItemLike)MNDItems.HOT_WINGS.get(), 3).requires((ItemLike)Items.BUCKET).unlockedBy("has_hot_wings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOT_WINGS_BUCKET.get(), (ItemLike)MNDItems.HOT_WINGS.get()})).save(output, "mynethersdelight:crafting/hot_wings_bucket");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.HOT_WINGS.get()), (int)3).requires((ItemLike)MNDItems.HOT_WINGS_BUCKET.get()).requires((ItemLike)Items.BOWL, 3).unlockedBy("has_hot_wings", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MNDItems.HOT_WINGS_BUCKET.get(), (ItemLike)MNDItems.HOT_WINGS.get()})).save(output, "mynethersdelight:crafting/hot_wings_bucket_alt");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.BURNT_ROLL.get())).requires((ItemLike)Items.MAGMA_CREAM).requires(Tags.Items.FOODS_RAW_MEAT).unlockedBy("has_magma_cream", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MAGMA_CREAM})).save(output, "mynethersdelight:crafting/burnt_roll");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.ROCK_SOUP.get())).requires((ItemLike)Items.MAGMA_CREAM, 2).requires((ItemLike)MNDItems.STRIDER_EGG.get(), 2).requires((ItemLike)Items.BOWL).unlockedBy("has_magma_cream", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MAGMA_CREAM})).save(output, "mynethersdelight:crafting/rock_soup");
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.MAGMA_CAKE.get())).pattern("MMM").pattern("PHP").pattern("###").define(Character.valueOf('H'), (ItemLike)MNDItems.HOT_CREAM.get()).define(Character.valueOf('M'), (ItemLike)Items.MAGMA_CREAM).define(Character.valueOf('#'), (ItemLike)ModItems.STRAW.get()).define(Character.valueOf('P'), (ItemLike)MNDItems.PEPPER_POWDER.get()).unlockedBy("has_magma_cream", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MAGMA_CREAM})).save(output, "mynethersdelight:crafting/magma_cake");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)MNDItems.MAGMA_CAKE.get())).requires((ItemLike)MNDItems.MAGMA_CAKE_SLICE.get(), 7).unlockedBy("has_magma_cream", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{Items.MAGMA_CREAM})).save(output, "mynethersdelight:crafting/magma_cake_alt");
    }

    private static Ingredient vegetablesPatch() {
        return DifferenceIngredient.of((Ingredient)Ingredient.of((TagKey)Tags.Items.FOODS_VEGETABLE), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.MELON_SLICE}));
    }
}

