/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block.trophies;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AbstractTrophyBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HIT = BooleanProperty.create((String)"hit");
    private final double pushStrength;
    private final double pushVertical;

    public AbstractTrophyBlock(BlockBehaviour.Properties properties, double pushStrength, double pushVerticalStrength) {
        super(properties);
        this.pushStrength = pushStrength;
        this.pushVertical = pushVerticalStrength;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HIT, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = this.defaultBlockState();
        Level levelReader = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            Direction oppositeDirection;
            if (!direction.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)(oppositeDirection = direction.getOpposite()))).canSurvive((LevelReader)levelReader, blockPos)) continue;
            return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos adjacentPos = pos.relative(direction.getOpposite());
        return level.getBlockState(adjacentPos).isFaceSturdy((BlockGetter)level, adjacentPos, direction);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (movedByPiston) {
            if (((Boolean)state.getValue((Property)HIT)).booleanValue()) {
                level.setBlock(pos, (BlockState)state.setValue((Property)HIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.pushEntities(level, pos, state);
        }
        super.onPlace(state, level, pos, oldState, movedByPiston);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide() && level.hasNeighborSignal(pos)) {
            this.pushEntities(level, pos, state);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide() && level.hasNeighborSignal(pos) && !entity.isSteppingCarefully()) {
            this.pushEntity(entity, state, pos, level);
        }
    }

    private void pushEntities(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        AABB searchBox = new AABB(pos).expandTowards((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
        for (Entity entity : level.getEntities(null, searchBox)) {
            this.pushEntity(entity, state, pos, level);
        }
    }

    private void pushEntity(Entity entity, BlockState state, BlockPos pos, Level level) {
        if (((Boolean)state.getValue((Property)HIT)).booleanValue()) {
            return;
        }
        Direction dir = (Direction)state.getValue((Property)FACING);
        double strength = this.pushStrength;
        double verticalStrength = this.pushVertical;
        Vec3 motion = new Vec3((double)dir.getStepX() * strength, verticalStrength, (double)dir.getStepZ() * strength);
        entity.setDeltaMovement(motion);
        entity.hurtMarked = true;
        level.playSound(null, pos, SoundEvents.HOGLIN_ATTACK, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.setBlock(pos, (BlockState)state.setValue((Property)HIT, (Comparable)Boolean.valueOf(true)), 3);
        level.scheduleTick(pos, (Block)this, 10);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)HIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, HIT});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return false;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_OTHER;
    }
}

