/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block.feasts;

import com.soytutta.mynethersdelight.common.registry.MNDItems;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class MagmaCakeBlock
extends Block {
    public static final BooleanProperty SECOND_CAKE = BooleanProperty.create((String)"second_cake");
    public static final DirectionProperty SECOND_CAKE_FACING = DirectionProperty.create((String)"second_facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)6);
    protected static final VoxelShape[][] SHAPE_BY_BITE = new VoxelShape[][]{{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)13.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)11.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)9.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)7.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)5.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)3.0)}, {Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)}, {Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)7.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)9.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)13.0, (double)15.0, (double)8.0, (double)15.0)}, {Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)13.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)11.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)9.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)7.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)8.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)8.0, (double)15.0)}};
    protected static final VoxelShape[][] SECOND_SHAPE_BY_BITE = new VoxelShape[][]{{Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)11.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)7.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)5.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)3.0), (BooleanOp)BooleanOp.OR)}, {Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)3.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)5.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)7.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)9.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)11.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)13.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR)}, {Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)3.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)5.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)7.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)9.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)13.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR)}, {Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)11.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)9.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)7.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)5.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR), Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), (VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)3.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.OR)}};
    public final Supplier<Item> pieSlice;

    public MagmaCakeBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties);
        this.pieSlice = pieSlice;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(false))).setValue((Property)SECOND_CAKE_FACING, (Comparable)Direction.NORTH));
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    public ItemStack getPieSliceItem() {
        return new ItemStack((ItemLike)this.pieSlice.get());
    }

    public int getMaxBites() {
        return 7;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean isSecondCake = (Boolean)state.getValue((Property)SECOND_CAKE);
        int second_direction = ((Direction)state.getValue((Property)SECOND_CAKE_FACING)).get2DDataValue();
        int direction = ((Direction)state.getValue((Property)FACING)).get2DDataValue();
        int bites = (Integer)state.getValue((Property)BITES);
        if (isSecondCake) {
            return SECOND_SHAPE_BY_BITE[second_direction][bites];
        }
        return SHAPE_BY_BITE[direction][bites];
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldStack.is(MNDItems.MAGMA_CAKE.get())) {
            return this.secondCake(level, pos, state, player);
        }
        if (heldStack.is(ModTags.KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.consumeBite(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.consumeBite(level, pos, state, player);
    }

    protected ItemInteractionResult secondCake(Level level, BlockPos pos, BlockState state, Player player) {
        Direction direction = player.getDirection().getOpposite();
        ItemStack heldStack = player.getMainHandItem();
        if ((Integer)state.getValue((Property)BITES) == 0 && !((Boolean)state.getValue((Property)SECOND_CAKE)).booleanValue()) {
            if (!player.isCreative()) {
                heldStack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.MAGMA_CUBE_SQUISH_SMALL, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)SECOND_CAKE_FACING, (Comparable)direction)).setValue((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(true)), 3);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected ItemInteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.getValue((Property)BITES);
        if (bites < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else if (((Boolean)state.getValue((Property)SECOND_CAKE)).booleanValue()) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        Direction direction = player.getDirection().getOpposite();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getPieSliceItem(), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
        level.playSound(null, pos, SoundEvents.MAGMA_CUBE_SQUISH, SoundSource.PLAYERS, 0.8f, 0.8f);
        return ItemInteractionResult.SUCCESS;
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        if (!playerIn.canEat(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getPieSliceItem();
        FoodProperties sliceFood = sliceStack.getItem().getFoodProperties(sliceStack, (LivingEntity)playerIn);
        if (sliceFood != null) {
            playerIn.getFoodData().eat(sliceFood);
            for (FoodProperties.PossibleEffect effect : sliceFood.effects()) {
                if (level.isClientSide || effect == null || !(level.random.nextFloat() < effect.probability())) continue;
                playerIn.addEffect(effect.effect());
            }
        }
        if ((bites = ((Integer)state.getValue((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else if (((Boolean)state.getValue((Property)SECOND_CAKE)).booleanValue()) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BITES, (Comparable)Integer.valueOf(0))).setValue((Property)SECOND_CAKE, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            level.removeBlock(pos, false);
        }
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!entity.isSteppingCarefully() && entity instanceof LivingEntity) {
            entity.hurt(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)DamageTypes.HOT_FLOOR), 1.0f);
        }
        super.stepOn(level, pos, state, entity);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BITES, SECOND_CAKE, SECOND_CAKE_FACING});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.animateTick(state, level, pos, rand);
        VoxelShape shape = this.getShape(state, (BlockGetter)level, pos, CollisionContext.empty());
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            int i = 0;
            while ((double)i < 0.025) {
                double particleX = minX + (maxX - minX) * rand.nextDouble() + (double)pos.getX();
                double particleY = minY + (maxY - minY) * rand.nextDouble() + (double)pos.getY();
                double particleZ = minZ + (maxZ - minZ) * rand.nextDouble() + (double)pos.getZ();
                double offsetX = (rand.nextDouble() - 0.5) * 0.45;
                double offsetY = (rand.nextDouble() - 0.5) * 0.45;
                double offsetZ = (rand.nextDouble() - 0.5) * 0.45;
                level.addParticle((ParticleOptions)ParticleTypes.FLAME, particleX + offsetX, particleY + offsetY, particleZ + offsetZ, 0.0, 0.0, 0.0);
                ++i;
            }
        });
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.getValue((Property)BITES);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return PathType.DAMAGE_FIRE;
    }
}

