/*
 * Decompiled with CFR 0.152.
 */
package com.soytutta.mynethersdelight.common.block.entity;

import com.soytutta.mynethersdelight.common.registry.MNDBlockEntityTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class NetherStoveBlockEntity
extends SyncedBlockEntity {
    private static final VoxelShape GRILLING_AREA = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    private final ItemStackHandler inventory = this.createHandler();
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private final RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> quickCheck = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);

    public NetherStoveBlockEntity(BlockPos pos, BlockState state) {
        super(MNDBlockEntityTypes.NETHER_STOVE.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Inventory")) {
            this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        } else {
            this.inventory.deserializeNBT(registries, tag);
        }
        if (tag.contains("CookingTimes", 11)) {
            int[] arrayCookingTimes = tag.getIntArray("CookingTimes");
            System.arraycopy(arrayCookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimes.length));
        }
        if (tag.contains("CookingTotalTimes", 11)) {
            int[] arrayCookingTimesTotal = tag.getIntArray("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        this.writeItems(compound, registries);
        compound.putIntArray("CookingTimes", this.cookingTimes);
        compound.putIntArray("CookingTotalTimes", this.cookingTimesTotal);
    }

    private CompoundTag writeItems(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        return compound;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, NetherStoveBlockEntity stove) {
        boolean isStoveLit = (Boolean)state.getValue((Property)StoveBlock.LIT);
        if (stove.isStoveBlockedAbove()) {
            if (!ItemUtils.isInventoryEmpty((IItemHandler)stove.inventory)) {
                ItemUtils.dropItems((Level)level, (BlockPos)pos, (IItemHandler)stove.inventory);
                stove.inventoryChanged();
            }
        } else if (isStoveLit) {
            stove.cookAndOutputItems();
        } else {
            for (int i = 0; i < stove.inventory.getSlots(); ++i) {
                if (stove.cookingTimes[i] <= 0) continue;
                stove.cookingTimes[i] = Mth.clamp((int)(stove.cookingTimes[i] - 2), (int)0, (int)stove.cookingTimesTotal[i]);
            }
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, NetherStoveBlockEntity stove) {
        for (int i = 0; i < stove.inventory.getSlots(); ++i) {
            if (stove.inventory.getStackInSlot(i).isEmpty() || !(level.random.nextFloat() < 0.2f)) continue;
            Vec2 stoveItemVector = stove.getStoveItemOffset(i);
            Direction direction = (Direction)state.getValue((Property)StoveBlock.FACING);
            int directionIndex = direction.get2DDataValue();
            Vec2 offset = directionIndex % 2 == 0 ? stoveItemVector : new Vec2(stoveItemVector.y, stoveItemVector.x);
            double x = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * offset.x) + (double)((float)direction.getClockWise().getStepX() * offset.x);
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * offset.y) + (double)((float)direction.getClockWise().getStepZ() * offset.y);
            for (int k = 0; k < 3; ++k) {
                level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private void cookAndOutputItems() {
        if (this.level == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack resultStack;
            ItemStack stoveStack = this.inventory.getStackInSlot(i);
            if (stoveStack.isEmpty()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
            Optional<RecipeHolder<CampfireCookingRecipe>> recipe = this.getMatchingRecipe(stoveStack);
            if (recipe.isPresent() && !(resultStack = ((CampfireCookingRecipe)recipe.get().value()).getResultItem((HolderLookup.Provider)this.level.registryAccess())).isEmpty()) {
                ItemUtils.spawnItemEntity((Level)this.level, (ItemStack)resultStack.copy(), (double)((double)this.worldPosition.getX() + 0.5), (double)((double)this.worldPosition.getY() + 1.0), (double)((double)this.worldPosition.getZ() + 0.5), (double)(this.level.random.nextGaussian() * (double)0.01f), (double)0.1f, (double)(this.level.random.nextGaussian() * (double)0.01f));
            }
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack itemStackIn, RecipeHolder<CampfireCookingRecipe> recipe, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.inventory.getSlots() && (slotStack = this.inventory.getStackInSlot(slot)).isEmpty()) {
            this.cookingTimesTotal[slot] = ((CampfireCookingRecipe)recipe.value()).getCookingTime();
            this.cookingTimes[slot] = 0;
            this.inventory.setStackInSlot(slot, itemStackIn.split(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<RecipeHolder<CampfireCookingRecipe>> getMatchingRecipe(ItemStack stack) {
        if (this.level == null) {
            return Optional.empty();
        }
        return this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), this.level);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean isStoveBlockedAbove() {
        if (this.level != null) {
            BlockState above = this.level.getBlockState(this.worldPosition.above());
            return Shapes.joinIsNotEmpty((VoxelShape)GRILLING_AREA, (VoxelShape)above.getShape((BlockGetter)this.level, this.worldPosition.above()), (BooleanOp)BooleanOp.AND);
        }
        return false;
    }

    public Vec2 getStoveItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        Vec2[] OFFSETS = new Vec2[]{new Vec2(0.3f, 0.2f), new Vec2(0.0f, 0.2f), new Vec2(-0.3f, 0.2f), new Vec2(0.3f, -0.2f), new Vec2(0.0f, -0.2f), new Vec2(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.writeItems(new CompoundTag(), registries);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(this, 6){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

