/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.cloth;

import ca.fxco.moreculling.config.cloth.AbstractDynamicEntry;
import ca.fxco.moreculling.config.cloth.DynamicFloatSliderBuilder;
import com.mojang.blaze3d.platform.Window;
import java.util.function.Function;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class DynamicFloatSliderEntry
extends AbstractDynamicEntry<Float> {
    private final float minimum;
    private final float maximum;
    private final float step;
    private Function<Float, Component> textGetter = thevalue -> Component.literal((String)String.format("Value: %3.1f", thevalue));

    public DynamicFloatSliderEntry(DynamicFloatSliderBuilder builder, float minimum, float maximum, float step) {
        super(builder.getFieldNameKey(), builder.getResetButtonKey(), (Float)builder.getValue(), builder.getDefaultValue(), builder.saveConsumer, builder.changeConsumer, null, builder.isRequireRestart(), builder.getLocked());
        this.step = step;
        this.maximum = maximum;
        this.minimum = minimum;
        this.mainWidget.setMessage(this.textGetter.apply((Float)this.getValue()));
        this.setValue((Float)this.getValue());
        this.onChange();
    }

    private static float roundStep(float input, float step) {
        return (float)Math.round(input / step) * step;
    }

    public Function<Float, Component> getTextGetter() {
        return this.textGetter;
    }

    public void setTextGetter(Function<Float, Component> textGetter) {
        this.textGetter = textGetter;
        this.mainWidget.setMessage(textGetter.apply((Float)this.getValue()));
    }

    @Override
    public void setValue(Float value) {
        if (!this.isLocked() && this.isEnabled()) {
            value = Float.valueOf(DynamicFloatSliderEntry.roundStep(value.floatValue(), this.step));
            ((Slider)this.mainWidget).setValue((double)(Mth.clamp((float)value.floatValue(), (float)this.minimum, (float)this.maximum) - this.minimum) / (double)Math.abs(this.maximum - this.minimum));
            value = Float.valueOf(Math.min(Math.max(value.floatValue(), this.minimum), this.maximum));
            super.setValue(value);
            ((Slider)this.mainWidget).updateMessage();
        }
    }

    @Override
    protected AbstractWidget createMainWidget() {
        return new Slider(0, 0, 152, 20, ((double)((Float)this.getValue()).floatValue() - (double)this.minimum) / (double)Math.abs(this.maximum - this.minimum));
    }

    @Override
    protected void onRender(GuiGraphics drawContext, int y, int x, int entryWidth, int entryHeight) {
        Window window = Minecraft.getInstance().getWindow();
        Component displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.getInstance().font.isBidirectional()) {
            drawContext.drawString(Minecraft.getInstance().font, displayedFieldName.getVisualOrderText(), window.getGuiScaledWidth() - x - Minecraft.getInstance().font.width((FormattedText)displayedFieldName), y + 6, this.getPreferredTextColor());
            this.resetButton.setX(x);
            this.mainWidget.setX(x + this.resetButton.getWidth() + 1);
        } else {
            drawContext.drawString(Minecraft.getInstance().font, displayedFieldName.getVisualOrderText(), x, y + 6, this.getPreferredTextColor());
            this.resetButton.setX(x + entryWidth - this.resetButton.getWidth());
            this.mainWidget.setX(x + entryWidth - 150);
        }
        this.mainWidget.setWidth(150 - this.resetButton.getWidth() - 2);
    }

    private class Slider
    extends AbstractSliderButton {
        protected Slider(int x, int y, int width, int height, double value) {
            super(x, y, width, height, GameNarrator.NO_TITLE, value);
        }

        public void updateMessage() {
            this.setMessage(DynamicFloatSliderEntry.this.textGetter.apply((Float)DynamicFloatSliderEntry.this.getValue()));
        }

        protected void applyValue() {
            DynamicFloatSliderEntry.this.setValue(Float.valueOf(DynamicFloatSliderEntry.roundStep((float)((double)DynamicFloatSliderEntry.this.minimum + (double)Math.abs(DynamicFloatSliderEntry.this.maximum - DynamicFloatSliderEntry.this.minimum) * this.value), DynamicFloatSliderEntry.this.step)));
        }

        public boolean keyPressed(int int_1, int int_2, int int_3) {
            return DynamicFloatSliderEntry.this.isEnabled() && DynamicFloatSliderEntry.this.isEditable() && super.keyPressed(int_1, int_2, int_3);
        }

        public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
            return DynamicFloatSliderEntry.this.isEnabled() && DynamicFloatSliderEntry.this.isEditable() && super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }

        public double getProgress() {
            return this.value;
        }

        public void setProgress(double f) {
            this.value = f;
        }

        public void setValue(double f) {
            this.value = f;
        }
    }
}

