/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.network;

import com.mojang.serialization.Codec;
import corgitaco.corgilib.CorgiLib;
import corgitaco.corgilib.network.Packet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.Nullable;

public record UpdateStructureBoxPacketC2S(BlockPos pos, BlockPos structureOffset, BoundingBox box) implements Packet
{
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateStructureBoxPacketC2S> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockPos.CODEC), UpdateStructureBoxPacketC2S::pos, (StreamCodec)ByteBufCodecs.fromCodec((Codec)BlockPos.CODEC), UpdateStructureBoxPacketC2S::structureOffset, (StreamCodec)ByteBufCodecs.fromCodec((Codec)BoundingBox.CODEC), UpdateStructureBoxPacketC2S::box, UpdateStructureBoxPacketC2S::new);
    public static final CustomPacketPayload.Type<UpdateStructureBoxPacketC2S> TYPE = new CustomPacketPayload.Type(CorgiLib.createLocation("update_structure"));

    @Override
    public void handle(@Nullable Level level, @Nullable Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(this.pos)) instanceof StructureBlockEntity) {
            StructureBlockEntity structureBlockEntity = (StructureBlockEntity)blockEntity;
            structureBlockEntity.setStructurePos(new BlockPos(this.structureOffset.getX(), this.structureOffset.getY(), this.structureOffset.getZ()));
            structureBlockEntity.setStructureSize(this.box.getLength());
            structureBlockEntity.setChanged();
            BlockState blockState = level.getBlockState(this.pos);
            level.sendBlockUpdated(this.pos, blockState, blockState, 3);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return null;
    }
}

