/*
 * Decompiled with CFR 0.152.
 */
package pkgbadges.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import pkgbadges.init.PkgbadgesModItems;
import pkgbadges.network.CraftItemPacket;
import pkgbadges.world.inventory.PokeFashionWorkshopGUIMenu;

public class PokeFashionWorkshopGUIScreen
extends AbstractContainerScreen<PokeFashionWorkshopGUIMenu> {
    private static final HashMap<String, Object> guistate = PokeFashionWorkshopGUIMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private float rotationAngle = 0.0f;
    private long lastCraftTime = 0L;
    private static final long COOLDOWN_PERIOD_MS = 4000L;
    private final List<Item> backpackItems = Arrays.asList((Item)PkgbadgesModItems.TRAINER_BACKPACK.get(), (Item)PkgbadgesModItems.TRAINER_BACKPACK_GREEN.get(), (Item)PkgbadgesModItems.TRAINER_BACKPACK_ORANGE.get(), (Item)PkgbadgesModItems.TRAINER_BACKPACK_PINK.get(), (Item)PkgbadgesModItems.MISTYS_BACKPACK.get(), (Item)PkgbadgesModItems.BROCKS_BACKPACK.get(), (Item)PkgbadgesModItems.BONNIE_WAIST_BAG.get(), (Item)PkgbadgesModItems.SERENA_BACKPACK.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_BACKPACK.get(), (Item)PkgbadgesModItems.CHARMANDER_BACKPACK.get(), (Item)PkgbadgesModItems.GENGAR_BACKPACK.get());
    private final List<Item> hatItems = Arrays.asList((Item)PkgbadgesModItems.ASH_KETCHUM_INDIGO_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_JOHTO_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_SINNOH_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_HOENN_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_UNOVA_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_KALOS_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_ALOLA_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_GALAR_LEAGUE_HAT.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_I_CHOOSE_YOU_HAT.get(), (Item)PkgbadgesModItems.PIKACHU_HAT.get(), (Item)PkgbadgesModItems.BULBASAUR_HAT.get(), (Item)PkgbadgesModItems.EEVEE_HAT.get(), (Item)PkgbadgesModItems.SQUIRTLE_HAT.get(), (Item)PkgbadgesModItems.SNORLAX_HAT.get(), (Item)PkgbadgesModItems.PIKACHU_NEW_YEAR_HELMET.get(), (Item)PkgbadgesModItems.PIKACHU_NEW_YEAR_SHINY_HELMET.get(), (Item)PkgbadgesModItems.EEVEE_NEW_YEAR_HELMET.get(), (Item)PkgbadgesModItems.EEVEE_NEW_YEAR_SHINY_HELMET.get(), (Item)PkgbadgesModItems.NINETALES_HELMET.get(), (Item)PkgbadgesModItems.NINETALES_SHINY_HELMET.get(), (Item)PkgbadgesModItems.ALOLA_NINETALES_HELMET.get(), (Item)PkgbadgesModItems.ALOLA_NINETALES_SHINY_HELMET.get(), (Item)PkgbadgesModItems.LEON_HAT.get(), (Item)PkgbadgesModItems.FRIEDE_GLASSES.get(), (Item)PkgbadgesModItems.CAPTAIN_HAT.get(), (Item)PkgbadgesModItems.SERENA_HELMET.get(), (Item)PkgbadgesModItems.SERENA_GALAR_HELMET.get(), (Item)PkgbadgesModItems.ROCKET_TEAM_HAT.get(), (Item)PkgbadgesModItems.HARD_HELMET.get(), (Item)PkgbadgesModItems.ALIANS_SCRAF_HELMET.get(), (Item)PkgbadgesModItems.KORRINA_HELMET.get(), (Item)PkgbadgesModItems.POLICE_HAT.get(), (Item)PkgbadgesModItems.NURSE_HELMET.get(), (Item)PkgbadgesModItems.CHARMANDER_RACER_HELMET.get(), (Item)PkgbadgesModItems.SQUIRTLE_RACER_HELMET.get(), (Item)PkgbadgesModItems.JIGGLYPUFF_RACER_HELMET.get(), (Item)PkgbadgesModItems.PIKACHU_RACER_HELMET.get(), (Item)PkgbadgesModItems.MEOWTH_RACER_HELMET.get(), (Item)PkgbadgesModItems.EEVEE_RACER_HELMET.get(), (Item)PkgbadgesModItems.GASTLY_RACER_HELMET.get(), (Item)PkgbadgesModItems.BULBASAUR_RACER_HELMET.get());
    private final List<Item> outfitItems = Arrays.asList((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_CHESTPLATE.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_BOOTS.get(), (Item)PkgbadgesModItems.GARY_OAK_CLOTH_CHESTPLATE.get(), (Item)PkgbadgesModItems.GARY_OAK_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.GARY_OAK_CLOTH_BOOTS.get(), (Item)PkgbadgesModItems.FRIEDE_CLOTH_CHESTPLATE.get(), (Item)PkgbadgesModItems.FRIEDE_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.FRIEDE_CLOTH_BOOTS.get(), (Item)PkgbadgesModItems.STEVEN_STONE_CLOTH_CHESTPLATE.get(), (Item)PkgbadgesModItems.STEVEN_STONE_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.STEVEN_STONE_CLOTH_BOOTS.get(), (Item)PkgbadgesModItems.ORLA_CLOTH_CHESTPLATE.get(), (Item)PkgbadgesModItems.ORLA_CLOTH_LEGGINGS.get(), (Item)PkgbadgesModItems.ORLA_CLOTH_BOOTS.get());
    private int currentItemIndex = 0;
    private List<Item> currentCategoryItems = this.backpackItems;
    ImageButton imagebutton_poke_fashion_workshop_gui_denext;
    ImageButton imagebutton_poke_fashion_workshop_gui_next;
    ImageButton imagebutton_poke_fashion_workshop_gui_assemb;
    ImageButton poke_fashion_workshop_gui_cloth;
    ImageButton poke_fashion_workshop_gui_hat;
    ImageButton poke_fashion_workshop_gui_backpack;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"pkgbadges:textures/screens/pokefashion_workshop_gui.png");

    public PokeFashionWorkshopGUIScreen(PokeFashionWorkshopGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 256;
        this.imageHeight = 191;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.entity == null || this.entity.getInventory() == null) {
            return;
        }
        Item selectedItem = this.currentCategoryItems.get(this.currentItemIndex);
        List<ItemStack> materials = this.getRequiredMaterials(selectedItem);
        this.render3DModel(guiGraphics, this.leftPos + 180, this.topPos + 110, 40, 0.0f, 0.0f, 0.0f);
        int xPos = 192;
        int yPos = 65;
        float scale = 0.6f;
        for (ItemStack material : materials) {
            if (material.isEmpty()) continue;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(scale, scale, scale);
            int itemCountInInventory = this.getItemCountInInventory(material);
            boolean hasMaterial = itemCountInInventory >= material.getCount();
            int color = hasMaterial ? 65280 : 0xFF0000;
            MutableComponent materialText = Component.literal((String)(itemCountInInventory + "/" + material.getCount() + " " + (material.getHoverName() != null ? material.getHoverName().getString() : "Unknown Item")));
            if (this.font != null) {
                guiGraphics.drawString(this.font, (Component)materialText, (int)((float)xPos / scale), (int)((float)yPos / scale), color, false);
            }
            yPos += 18;
            guiGraphics.pose().popPose();
        }
    }

    private void render3DModel(GuiGraphics guiGraphics, int x, int y, int scale, float rotationX, float rotationY, float rotationZ) {
        if (this.currentItemIndex < 0 || this.currentItemIndex >= this.currentCategoryItems.size()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)this.currentCategoryItems.get(this.currentItemIndex));
        Item item = stack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            guiGraphics.pose().pushPose();
            if (this.currentCategoryItems == this.backpackItems) {
                guiGraphics.pose().translate(85.0f, 93.0f, 100.0f);
            } else if (this.currentCategoryItems == this.hatItems) {
                guiGraphics.pose().translate(85.0f, 125.0f, 100.0f);
            } else if (this.currentCategoryItems == this.outfitItems) {
                guiGraphics.pose().translate(85.0f, 90.0f, 100.0f);
            }
            guiGraphics.pose().scale((float)scale, (float)scale, (float)scale);
            guiGraphics.pose().mulPose(Axis.XP.rotationDegrees(rotationX));
            guiGraphics.pose().mulPose(Axis.YP.rotationDegrees(this.rotationAngle));
            guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
            Minecraft minecraft = Minecraft.getInstance();
            EntityRenderDispatcher entityRenderDispatcher = minecraft.getEntityRenderDispatcher();
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            HumanoidModel model = new HumanoidModel(minecraft.getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
            ArmorStand armorStand = new ArmorStand((Level)minecraft.level, 0.0, 0.0, 0.0);
            armorStand.setItemSlot(armorItem.getEquipmentSlot(), stack);
            armorStand.setInvisible(true);
            armorStand.setNoBasePlate(true);
            entityRenderDispatcher.render((Entity)armorStand, 0.0, 0.0, 0.0, 0.0f, 1.0f, guiGraphics.pose(), (MultiBufferSource)bufferSource, 0xF000F0);
            bufferSource.endBatch();
            guiGraphics.pose().popPose();
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
        }
        this.rotationAngle += 1.0f;
        if (this.rotationAngle >= 360.0f) {
            this.rotationAngle = 0.0f;
        }
    }

    private int getItemCountInInventory(ItemStack material) {
        if (material.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (ItemStack itemStack : this.entity.getInventory().items) {
            if (itemStack.isEmpty() || !itemStack.is(material.getItem())) continue;
            count += itemStack.getCount();
        }
        return count;
    }

    private void selectCategory(String category) {
        switch (category) {
            case "backpack": {
                this.currentCategoryItems = this.backpackItems;
                break;
            }
            case "hat": {
                this.currentCategoryItems = this.hatItems;
                break;
            }
            case "clothes": {
                this.currentCategoryItems = this.outfitItems;
            }
        }
        this.currentItemIndex = 0;
        this.updateSelectedItem();
    }

    private void updateSelectedItem() {
        Item selectedItem = this.currentCategoryItems.get(this.currentItemIndex);
    }

    private List<ItemStack> getRequiredMaterials(Item item) {
        HashMap<Item, List<ItemStack>> materialMap = new HashMap<Item, List<ItemStack>>();
        materialMap.put((Item)PkgbadgesModItems.GENGAR_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)Items.CHEST, 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 10), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6)));
        materialMap.put((Item)PkgbadgesModItems.CHARMANDER_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)Items.CHEST, 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 3), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.SERENA_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.BONNIE_WAIST_BAG.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 8), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.BROCKS_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 12), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.MISTYS_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK_ORANGE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK_PINK.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.TRAINER_BACKPACK_GREEN.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)Items.CHEST, 1)));
        materialMap.put((Item)PkgbadgesModItems.ORLA_CLOTH_CHESTPLATE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.ORLA_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 6)));
        materialMap.put((Item)PkgbadgesModItems.ORLA_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_CHESTPLATE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.STEVEN_STONE_CLOTH_CHESTPLATE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 10), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.STEVEN_STONE_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.STEVEN_STONE_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_GLASSES.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 2), new ItemStack((ItemLike)Items.GOLD_NUGGET, 4)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_CLOTH_CHESTPLATE.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.FRIEDE_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.GARY_OAK_CLOTH_CHESTPLATE.get(), Arrays.asList(new ItemStack((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.GOLD_BLOCK, 1), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.GARY_OAK_CLOTH_LEGGINGS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.GARY_OAK_CLOTH_BOOTS.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_INDIGO_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 1)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_JOHTO_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 1)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_SINNOH_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 5), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_HOENN_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 5), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_UNOVA_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_KALOS_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 12)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_ALOLA_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 4), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_GALAR_LEAGUE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.ASH_KETCHUM_I_CHOOSE_YOU_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.SERENA_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.TRILBY_HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.STRING, 2)));
        materialMap.put((Item)PkgbadgesModItems.SERENA_GALAR_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.TRILBY_HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 8), new ItemStack((ItemLike)Items.STRING, 2)));
        materialMap.put((Item)PkgbadgesModItems.LEON_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 16)));
        materialMap.put((Item)PkgbadgesModItems.JIGGLYPUFF_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PINK_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.SQUIRTLE_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.CHARMANDER_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.EEVEE_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.MEOWTH_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.BULBASAUR_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.PIKACHU_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.GASTLY_RACER_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 8), new ItemStack((ItemLike)Items.GLASS_PANE, 1), new ItemStack((ItemLike)Items.IRON_BLOCK, 1)));
        materialMap.put((Item)PkgbadgesModItems.EEVEE_NEW_YEAR_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.EEVEE_NEW_YEAR_SHINY_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.PIKACHU_NEW_YEAR_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 3)));
        materialMap.put((Item)PkgbadgesModItems.PIKACHU_NEW_YEAR_SHINY_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.GREEN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 3)));
        materialMap.put((Item)PkgbadgesModItems.ALOLA_NINETALES_SHINY_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 24), new ItemStack((ItemLike)PkgbadgesModItems.PURPLE_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 5), new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.ALOLA_NINETALES_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 1)));
        materialMap.put((Item)PkgbadgesModItems.NINETALES_SHINY_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.GRAY_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 3)));
        materialMap.put((Item)PkgbadgesModItems.NINETALES_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.ORANGE_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 3)));
        materialMap.put((Item)PkgbadgesModItems.SQUIRTLE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.CYAN_FABRIC.get(), 16), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.EEVEE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BROWN_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 4)));
        materialMap.put((Item)PkgbadgesModItems.BULBASAUR_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.LIME_GREEN_FABRIC.get(), 8), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.SNORLAX_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 6), new ItemStack((ItemLike)PkgbadgesModItems.CYAN_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 13)));
        materialMap.put((Item)PkgbadgesModItems.PIKACHU_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 12), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.NURSE_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 10)));
        materialMap.put((Item)PkgbadgesModItems.POLICE_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.DARK_BLUE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ROCKET_TEAM_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.RED_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.CAPTAIN_HAT.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)PkgbadgesModItems.BLACK_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.YELLOW_FABRIC.get(), 2), new ItemStack((ItemLike)PkgbadgesModItems.WHITE_FABRIC.get(), 8)));
        materialMap.put((Item)PkgbadgesModItems.ALIANS_SCRAF_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.BLUE_FABRIC.get(), 3), new ItemStack((ItemLike)PkgbadgesModItems.CYAN_FABRIC.get(), 2)));
        materialMap.put((Item)PkgbadgesModItems.KORRINA_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)Items.IRON_INGOT, 3), new ItemStack((ItemLike)Items.STRING, 2)));
        materialMap.put((Item)PkgbadgesModItems.HARD_HELMET.get(), Arrays.asList(new ItemStack((ItemLike)PkgbadgesModItems.HAT_TEMPLATE.get(), 1), new ItemStack((ItemLike)Items.IRON_INGOT, 8), new ItemStack((ItemLike)Items.YELLOW_DYE, 4)));
        if (materialMap.containsKey(item)) {
            return (List)materialMap.get(item);
        }
        return Collections.emptyList();
    }

    private void attemptCraftItem() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCraftTime < 4000L) {
            this.minecraft.player.displayClientMessage((Component)Component.literal((String)"Still cooling down!"), false);
            return;
        }
        this.lastCraftTime = currentTime;
        if (this.isInputSlotEmpty()) {
            this.minecraft.player.displayClientMessage((Component)Component.literal((String)"No coal!"), false);
            return;
        }
        Item itemToCraft = this.currentCategoryItems.get(this.currentItemIndex);
        if (!this.hasRequiredMaterials(itemToCraft)) {
            this.minecraft.player.displayClientMessage((Component)Component.literal((String)"Missing required materials!"), false);
            return;
        }
        ResourceLocation[] soundLocations = new ResourceLocation[]{ResourceLocation.parse((String)"pkgbadges:sewing"), ResourceLocation.parse((String)"pkgbadges:sewing_v2")};
        ResourceLocation soundToPlay = soundLocations[(int)(Math.random() * (double)soundLocations.length)];
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundToPlay)), (float)1.0f));
        new Thread(() -> {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.isInputSlotEmpty()) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Slot emptied during craft!"), false);
                return;
            }
            if (!this.hasRequiredMaterials(this.currentCategoryItems.get(this.currentItemIndex))) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Materials removed during craft!"), false);
                return;
            }
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"pkgbadges:sewing_finish"))), (float)1.0f));
        }).start();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)itemToCraft);
        Minecraft.getInstance().getConnection().send((CustomPacketPayload)new CraftItemPacket(itemId));
    }

    public static void handle(CraftItemPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Item item;
            if (context.player() != null && (item = (Item)BuiltInRegistries.ITEM.get(packet.itemId())) != null) {
                if (PokeFashionWorkshopGUIScreen.hasRequiredMaterials(context.player(), item)) {
                    PokeFashionWorkshopGUIScreen.removeMaterials(context.player(), item);
                    context.player().getInventory().add(new ItemStack((ItemLike)item));
                } else {
                    context.player().displayClientMessage((Component)Component.literal((String)"Missing required materials!"), false);
                }
            }
        });
    }

    private boolean hasRequiredMaterials(Item item) {
        List<ItemStack> requiredMaterials = this.getRequiredMaterials(item);
        for (ItemStack material : requiredMaterials) {
            int requiredAmount = material.getCount();
            int availableAmount = 0;
            for (ItemStack stack : this.entity.getInventory().items) {
                if (stack.getItem() != material.getItem()) continue;
                availableAmount += stack.getCount();
            }
            if (availableAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    private static boolean hasRequiredMaterials(Player player, Item item) {
        return true;
    }

    private static void removeMaterials(Player player, Item item) {
    }

    private boolean isInputSlotEmpty() {
        ItemStack inputSlotStack = ((PokeFashionWorkshopGUIMenu)this.menu).getSlot(0).getItem();
        return inputSlotStack.isEmpty();
    }

    public void init() {
        super.init();
        this.imagebutton_poke_fashion_workshop_gui_denext = new ImageButton(this, this.leftPos + 11, this.topPos + 22, 10, 11, new WidgetSprites(ResourceLocation.parse((String)"pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_denext.png"), ResourceLocation.parse((String)"pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_denext.png")), e -> {
            if (this.currentItemIndex > 0) {
                --this.currentItemIndex;
                this.updateSelectedItem();
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, 10, 11, 10, 11);
            }
        };
        guistate.put("button:imagebutton_poke_fashion_workshop_gui_denext", this.imagebutton_poke_fashion_workshop_gui_denext);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_poke_fashion_workshop_gui_denext);
        this.imagebutton_poke_fashion_workshop_gui_next = new ImageButton(this, this.leftPos + 158, this.topPos + 22, 10, 11, new WidgetSprites(ResourceLocation.parse((String)"pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_next.png"), ResourceLocation.parse((String)"pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_next.png")), e -> {
            if (this.currentItemIndex < this.currentCategoryItems.size() - 1) {
                ++this.currentItemIndex;
                this.updateSelectedItem();
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, 10, 11, 10, 11);
            }
        };
        guistate.put("button:imagebutton_poke_fashion_workshop_gui_next", this.imagebutton_poke_fashion_workshop_gui_next);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_poke_fashion_workshop_gui_next);
        this.imagebutton_poke_fashion_workshop_gui_assemb = new ImageButton(this, this.leftPos + 187, this.topPos + 36, 67, 12, new WidgetSprites(ResourceLocation.parse((String)"pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_assemb.png"), ResourceLocation.parse((String)"pkgbadges:textures/screens/atlas/imagebutton_poke_fashion_workshop_gui_assemb.png")), e -> this.attemptCraftItem()){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, 67, 12, 67, 12);
            }
        };
        guistate.put("button:imagebutton_poke_fashion_workshop_gui_assemb", this.imagebutton_poke_fashion_workshop_gui_assemb);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_poke_fashion_workshop_gui_assemb);
        this.poke_fashion_workshop_gui_cloth = new ImageButton(this, this.leftPos + 85, this.topPos + -17, 22, 20, new WidgetSprites(ResourceLocation.parse((String)"pkgbadges:textures/screens/poke_fashion_workshop_gui_cloth.png"), ResourceLocation.parse((String)"pkgbadges:textures/screens/poke_fashion_workshop_gui_cloth.png")), e -> this.selectCategory("clothes")){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:poke_fashion_workshop_gui_cloth", this.poke_fashion_workshop_gui_cloth);
        this.addRenderableWidget((GuiEventListener)this.poke_fashion_workshop_gui_cloth);
        this.poke_fashion_workshop_gui_hat = new ImageButton(this, this.leftPos + 51, this.topPos + -17, 22, 20, new WidgetSprites(ResourceLocation.parse((String)"pkgbadges:textures/screens/poke_fashion_workshop_gui_hat.png"), ResourceLocation.parse((String)"pkgbadges:textures/screens/poke_fashion_workshop_gui_hat.png")), e -> this.selectCategory("hat")){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:poke_fashion_workshop_gui_hat", this.poke_fashion_workshop_gui_hat);
        this.addRenderableWidget((GuiEventListener)this.poke_fashion_workshop_gui_hat);
        this.poke_fashion_workshop_gui_backpack = new ImageButton(this, this.leftPos + 19, this.topPos + -17, 22, 20, new WidgetSprites(ResourceLocation.parse((String)"pkgbadges:textures/screens/poke_fashion_workshop_gui_backpack.png"), ResourceLocation.parse((String)"pkgbadges:textures/screens/poke_fashion_workshop_gui_backpack.png")), e -> this.selectCategory("backpack")){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:poke_fashion_workshop_gui_backpack", this.poke_fashion_workshop_gui_backpack);
        this.addRenderableWidget((GuiEventListener)this.poke_fashion_workshop_gui_backpack);
    }
}

