/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.lucko.spark.common.util.config.Configuration;

public class FileConfiguration
implements Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path file;
    private JsonObject root;

    public FileConfiguration(Path file) {
        this.file = file;
        this.load();
    }

    @Override
    public void load() {
        JsonObject root = null;
        if (Files.exists(this.file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.file, StandardCharsets.UTF_8);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (root == null) {
            root = new JsonObject();
            root.addProperty("_header", "spark configuration file - https://spark.lucko.me/docs/Configuration");
        }
        this.root = root;
    }

    @Override
    public void save() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.file, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)this.root, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getString(String path, String def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        return el.getAsJsonPrimitive().getAsString();
    }

    @Override
    public boolean getBoolean(String path, boolean def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        JsonPrimitive val = el.getAsJsonPrimitive();
        return val.isBoolean() ? val.getAsBoolean() : def;
    }

    @Override
    public int getInteger(String path, int def) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonPrimitive()) {
            return def;
        }
        JsonPrimitive val = el.getAsJsonPrimitive();
        return val.isNumber() ? val.getAsInt() : def;
    }

    @Override
    public List<String> getStringList(String path) {
        JsonElement el = this.root.get(path);
        if (el == null || !el.isJsonArray()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement child : el.getAsJsonArray()) {
            if (!child.isJsonPrimitive()) continue;
            list.add(child.getAsJsonPrimitive().getAsString());
        }
        return list;
    }

    @Override
    public void setString(String path, String value) {
        this.root.add(path, (JsonElement)new JsonPrimitive(value));
    }

    @Override
    public void setBoolean(String path, boolean value) {
        this.root.add(path, (JsonElement)new JsonPrimitive(Boolean.valueOf(value)));
    }

    @Override
    public void setInteger(String path, int value) {
        this.root.add(path, (JsonElement)new JsonPrimitive((Number)value));
    }

    @Override
    public void setStringList(String path, List<String> value) {
        JsonArray array = new JsonArray();
        for (String str : value) {
            array.add(str);
        }
        this.root.add(path, (JsonElement)array);
    }

    @Override
    public boolean contains(String path) {
        return this.root.has(path);
    }

    @Override
    public void remove(String path) {
        this.root.remove(path);
    }
}

