/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.api.client.searchtree.v1.SearchRegistryHelper;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.client.TradingPostClient;
import fuzs.tradingpost.mixin.client.accessor.ButtonAccessor;
import fuzs.tradingpost.mixin.client.accessor.MerchantScreenAccessor;
import fuzs.tradingpost.network.client.C2SClearSlotsMessage;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import fuzs.tradingpost.world.level.block.entity.TradingPostBlockEntity;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class TradingPostScreen
extends MerchantScreen {
    public static final ResourceLocation MAGNIFYING_GLASS_LOCATION = TradingPost.id("container/villager/magnifying_glass");
    private static final ResourceLocation VILLAGER_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/gui/container/villager.png");
    private static final ResourceLocation OUT_OF_STOCK_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"container/villager/out_of_stock");
    private static final ResourceLocation DISCOUNT_STRIKETHRUOGH_SPRITE = ResourceLocationHelper.withDefaultNamespace((String)"container/villager/discount_strikethrough");
    private static final ResourceLocation CREATIVE_INVENTORY_LOCATION = ResourceLocationHelper.withDefaultNamespace((String)"textures/gui/container/creative_inventory/tab_item_search.png");
    public static final Component DEPRECATED_TRADE_COMPONENT = Component.translatable((String)"merchant.deprecated");
    public static final Component MERCHANT_UNAVAILABLE_COMPONENT = Component.translatable((String)"trading_post.trader_gone");
    private EditBox searchBox;
    private boolean ignoreTextInput;

    public TradingPostScreen(MerchantMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void init() {
        super.init();
        for (MerchantScreen.TradeOfferButton tradeOfferButton : this.tradeOfferButtons) {
            ((ButtonAccessor)tradeOfferButton).tradingpost$setOnPress(button -> {
                int shopItem = tradeOfferButton.getIndex() + ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
                MerchantOffers offers = this.getMenu().getOffers();
                ((MerchantScreenAccessor)((Object)this)).tradingpost$setShopItem(shopItem);
                this.getMenu().setSelectionHint(shopItem);
                this.getMenu().getTraders().setActiveOffer((MerchantOffer)offers.get(shopItem));
                this.getMenu().tryMoveItems(shopItem);
                this.minecraft.getConnection().send((Packet)new ServerboundSelectTradePacket(offers instanceof TradingPostOffers ? ((TradingPostOffers)offers).getOrigShopItem(shopItem) : shopItem));
            });
        }
        this.searchBox = new EditBox(this.font, this.leftPos + 13, this.topPos + 6, 80, 9, TradingPostBlockEntity.CONTAINER_COMPONENT);
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(0xFFFFFF);
        this.addWidget((GuiEventListener)this.searchBox);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String lastSearch = this.searchBox.getValue();
        super.resize(minecraft, width, height);
        this.searchBox.setValue(lastSearch);
        if (!this.searchBox.getValue().isEmpty()) {
            this.refreshSearchResults();
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component title = this.getMenu().getTraders().getDisplayName();
        if (title != null) {
            int traderLevel = ((MerchantMenu)this.menu).getTraderLevel();
            if (traderLevel > 0 && traderLevel <= 5 && ((MerchantMenu)this.menu).showProgressBar()) {
                title = title.copy().append(" - ").append((Component)Component.translatable((String)("merchant.level." + traderLevel)));
            }
        } else {
            title = this.title;
        }
        guiGraphics.drawString(this.font, title, 49 + this.imageWidth / 2 - this.font.width((FormattedText)title) / 2, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTime) {
        MerchantOffers merchantoffers = this.getMenu().getOffers();
        this.setButtonsActive(merchantoffers);
        int scrollOff = ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
        Slot hoveredSlot = this.hoveredSlot;
        this.lock(true, merchantoffers.size(), null);
        super.render(guiGraphics, mouseX, mouseY, partialTime);
        this.lock(false, scrollOff, hoveredSlot);
        if (!merchantoffers.isEmpty()) {
            MerchantOffer merchantoffer;
            int shopItemIndex = ((MerchantScreenAccessor)((Object)this)).tradingpost$getShopItem();
            if (shopItemIndex >= 0 && shopItemIndex < merchantoffers.size() && (merchantoffer = (MerchantOffer)merchantoffers.get(shopItemIndex)).isOutOfStock()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.blitSprite(OUT_OF_STOCK_SPRITE, this.leftPos + 83 + 99, this.topPos + 35, 0, 28, 21);
            }
            int posX = this.leftPos + 5;
            int posY = this.topPos + 16 + 2;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)VILLAGER_LOCATION);
            ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderScroller(guiGraphics, this.leftPos, this.topPos, merchantoffers);
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer merchantoffer2 = (MerchantOffer)merchantoffers.get(i);
                ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderButtonArrows(guiGraphics, merchantoffer2, this.leftPos, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    guiGraphics.fill(posX, posY, posX + 88, posY + 20, 0x30FF0000);
                }
                ItemStack baseCostA = merchantoffer2.getBaseCostA();
                ItemStack costA = merchantoffer2.getCostA();
                ItemStack costB = merchantoffer2.getCostB();
                ItemStack result = merchantoffer2.getResult();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    RenderSystem.depthFunc((int)516);
                    guiGraphics.fill(posX, posY, posX + 88, posY + 20, 0x30FFFFFF);
                    RenderSystem.depthFunc((int)515);
                }
                this.renderAndDecorateCostA(guiGraphics, posX, posY, baseCostA, costA);
                if (!costB.isEmpty()) {
                    guiGraphics.renderFakeItem(costB, posX + 35, posY + 1);
                    guiGraphics.renderItemDecorations(this.font, costB, posX + 35, posY + 1);
                }
                guiGraphics.renderFakeItem(result, posX + 68, posY + 1);
                guiGraphics.renderItemDecorations(this.font, result, posX + 68, posY + 1);
                guiGraphics.pose().popPose();
                posY += 20;
            }
            MerchantOffer activeOffer = (MerchantOffer)merchantoffers.get(shopItemIndex);
            if (this.getMenu().showProgressBar()) {
                ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderProgressBar(guiGraphics, this.leftPos, this.topPos, activeOffer);
            }
            if (activeOffer.isOutOfStock() && this.isHovering(186, 35, 22, 21, mouseX, mouseY) && this.getMenu().canRestock()) {
                guiGraphics.renderTooltip(this.font, DEPRECATED_TRADE_COMPONENT, mouseX, mouseY);
            }
            posY = this.topPos + 16 + 2;
            int merchantoffersSize2 = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize2; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer merchantoffer3 = (MerchantOffer)merchantoffers.get(i);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer3) && this.isHovering(posX, posY, 88, 19, mouseX + this.leftPos, mouseY + this.topPos)) {
                    guiGraphics.renderTooltip(this.font, MERCHANT_UNAVAILABLE_COMPONENT, mouseX, mouseY);
                }
                posY += 20;
            }
            RenderSystem.enableDepthTest();
        }
        int offerButtonsLength = this.tradeOfferButtons.length;
        for (int i = 0; i < offerButtonsLength; ++i) {
            MerchantScreen.TradeOfferButton tradeOfferButton = this.tradeOfferButtons[i];
            if (tradeOfferButton.active && tradeOfferButton.isHoveredOrFocused()) {
                tradeOfferButton.renderToolTip(guiGraphics, mouseX, mouseY);
            }
            tradeOfferButton.visible = i < this.getMenu().getOffers().size();
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderAndDecorateCostA(GuiGraphics guiGraphics, int posX, int posY, ItemStack baseCostA, ItemStack costA) {
        guiGraphics.renderFakeItem(costA, posX + 5, posY + 1);
        if (baseCostA.getCount() == costA.getCount()) {
            guiGraphics.renderItemDecorations(this.font, costA, posX + 5, posY + 1);
        } else {
            guiGraphics.renderItemDecorations(this.font, baseCostA, posX + 5, posY + 1, baseCostA.getCount() == 1 ? "1" : null);
            guiGraphics.renderItemDecorations(this.font, costA, posX + 5 + 14, posY + 1, costA.getCount() == 1 ? "1" : null);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
            guiGraphics.blitSprite(DISCOUNT_STRIKETHRUOGH_SPRITE, posX + 5 + 7, posY + 1 + 12, 0, 9, 2);
            guiGraphics.pose().popPose();
        }
    }

    private void setButtonsActive(MerchantOffers merchantoffers) {
        if (!merchantoffers.isEmpty()) {
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                int scrollOff = ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                MerchantOffer offer = (MerchantOffer)merchantoffers.get(i);
                this.tradeOfferButtons[i - scrollOff].active = this.getMenu().getTraders().checkOffer(offer);
            }
        }
    }

    private void lock(boolean lockOffers, int newScrollOff, Slot newHoveredSlot) {
        this.getMenu().lockOffers(lockOffers);
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setScrollOff(newScrollOff);
        this.hoveredSlot = newHoveredSlot;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        guiGraphics.blit(CREATIVE_INVENTORY_LOCATION, this.leftPos + 11, this.topPos + 4, 0, 80.0f, 4.0f, 90, 12, 256, 256);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blitSprite(MAGNIFYING_GLASS_LOCATION, this.leftPos, this.topPos + 4, 0, 16, 16);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)VILLAGER_LOCATION);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseKey) {
        if (this.searchBox.mouseClicked(mouseX, mouseY, mouseKey)) {
            this.searchBox.setFocused(true);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseKey);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifierKeys) {
        this.ignoreTextInput = false;
        String lastSearch = this.searchBox.getValue().trim();
        if (this.searchBox.keyPressed(keyCode, scanCode, modifierKeys)) {
            if (!Objects.equals(this.searchBox.getValue().trim(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.searchBox.isFocused() && this.searchBox.isVisible() && keyCode != 256) {
            return true;
        }
        if (this.minecraft.options.keyChat.matches(keyCode, scanCode) && !this.searchBox.isFocused()) {
            this.ignoreTextInput = true;
            this.searchBox.setFocused(true);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifierKeys);
    }

    public boolean charTyped(char typedChar, int modifierKeys) {
        String lastSearch = this.searchBox.getValue().trim();
        if (!this.ignoreTextInput && this.searchBox.charTyped(typedChar, modifierKeys)) {
            if (!Objects.equals(this.searchBox.getValue().trim(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        return super.charTyped(typedChar, modifierKeys);
    }

    public void refreshSearchResults() {
        MerchantOffers merchantOffers = this.getMenu().getOffers();
        if (!(merchantOffers instanceof TradingPostOffers)) {
            return;
        }
        TradingPostOffers offers = (TradingPostOffers)merchantOffers;
        String query = this.searchBox.getValue().trim();
        if (query.isEmpty()) {
            offers.clearFilter();
        } else {
            SearchTree searchTree = SearchRegistryHelper.getSearchTree(TradingPostClient.MERCHANT_OFFERS_SEARCH_TREE);
            offers.setFilter(searchTree.search(query.toLowerCase(Locale.ROOT)));
        }
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setScrollOff(0);
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setShopItem(0);
        this.getMenu().setSelectionHint(-1);
        this.getMenu().getTraders().setActiveOffer(null);
        this.getMenu().clearPaymentSlots();
        TradingPost.NETWORK.sendToServer(new C2SClearSlotsMessage().toServerboundMessage());
    }

    public TradingPostMenu getMenu() {
        return (TradingPostMenu)super.getMenu();
    }
}

