/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.registry.registries;

import com.arcaryx.cobblemonintegrations.CobblemonIntegrations;
import com.arcaryx.cobblemonintegrations.client.net.clienthandling.SyncDropsHandler;
import com.arcaryx.cobblemonintegrations.client.net.clienthandling.SyncEvoItemsHandler;
import com.arcaryx.cobblemonintegrations.net.packets.client.SyncDropsPacket;
import com.arcaryx.cobblemonintegrations.net.packets.client.SyncEvoItemsPacket;
import com.arcaryx.cobblemonintegrations.net.packets.server.WaystonesInteractPacket;
import com.arcaryx.cobblemonintegrations.net.serverhandling.WaystonesInteractHandler;
import com.arcaryx.cobblemonintegrations.util.MiscUtilsKt;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.net.PacketHandler;
import com.cobblemon.mod.common.net.PacketRegisterInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u0012\u0010\n\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u0012\u0010\u000b\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ \u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tJ\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0002J\u0012\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010H\u0002R\u001b\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/arcaryx/cobblemonintegrations/registry/registries/CobblemonIntegrationsNetwork;", "", "<init>", "()V", "sendToPlayer", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "packet", "Lcom/cobblemon/mod/common/api/net/NetworkPacket;", "sendToServer", "sendToAllPlayers", "sendPacketToPlayers", "players", "", "s2cPayloads", "", "Lcom/cobblemon/mod/common/net/PacketRegisterInfo;", "getS2cPayloads", "()Ljava/util/List;", "c2sPayloads", "getC2sPayloads", "generateS2CPacketInfoList", "generateC2SPacketInfoList", "cobblemonintegrations-common-1.21.1"})
@SourceDebugExtension(value={"SMAP\nCobblemonIntegrationsNetwork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobblemonIntegrationsNetwork.kt\ncom/arcaryx/cobblemonintegrations/registry/registries/CobblemonIntegrationsNetwork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1869#2,2:47\n*S KotlinDebug\n*F\n+ 1 CobblemonIntegrationsNetwork.kt\ncom/arcaryx/cobblemonintegrations/registry/registries/CobblemonIntegrationsNetwork\n*L\n25#1:47,2\n*E\n"})
public final class CobblemonIntegrationsNetwork {
    @NotNull
    public static final CobblemonIntegrationsNetwork INSTANCE = new CobblemonIntegrationsNetwork();
    @NotNull
    private static final List<PacketRegisterInfo<?>> s2cPayloads = INSTANCE.generateS2CPacketInfoList();
    @NotNull
    private static final List<PacketRegisterInfo<?>> c2sPayloads = INSTANCE.generateC2SPacketInfoList();

    private CobblemonIntegrationsNetwork() {
    }

    public final void sendToPlayer(@NotNull ServerPlayer player, @NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        CobblemonIntegrations.INSTANCE.getPlatform().getNetworkManager().sendToPlayer(player, packet);
    }

    public final void sendToServer(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        CobblemonIntegrations.INSTANCE.getPlatform().getNetworkManager().sendToServer(packet);
    }

    public final void sendToAllPlayers(@NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        MinecraftServer minecraftServer = MiscUtilsKt.server();
        Intrinsics.checkNotNull((Object)minecraftServer);
        List list = minecraftServer.getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        this.sendPacketToPlayers(list, packet);
    }

    public final void sendPacketToPlayers(@NotNull Iterable<? extends ServerPlayer> players, @NotNull NetworkPacket<?> packet) {
        Intrinsics.checkNotNullParameter(players, (String)"players");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        Iterable<? extends ServerPlayer> $this$forEach$iv = players;
        boolean $i$f$forEach = false;
        Iterator<? extends ServerPlayer> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            ServerPlayer element$iv;
            ServerPlayer it = element$iv = iterator.next();
            boolean bl = false;
            INSTANCE.sendToPlayer(it, packet);
        }
    }

    @NotNull
    public final List<PacketRegisterInfo<?>> getS2cPayloads() {
        return s2cPayloads;
    }

    @NotNull
    public final List<PacketRegisterInfo<?>> getC2sPayloads() {
        return c2sPayloads;
    }

    private final List<PacketRegisterInfo<?>> generateS2CPacketInfoList() {
        List list = new ArrayList();
        ResourceLocation resourceLocation = SyncDropsPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation, (Function1)new Function1<RegistryFriendlyByteBuf, SyncDropsPacket>((Object)SyncDropsPacket.Companion){

            public final SyncDropsPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SyncDropsPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)SyncDropsHandler.INSTANCE, null, 8, null));
        ResourceLocation resourceLocation2 = SyncEvoItemsPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation2, (Function1)new Function1<RegistryFriendlyByteBuf, SyncEvoItemsPacket>((Object)SyncEvoItemsPacket.Companion){

            public final SyncEvoItemsPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((SyncEvoItemsPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)SyncEvoItemsHandler.INSTANCE, null, 8, null));
        return list;
    }

    private final List<PacketRegisterInfo<?>> generateC2SPacketInfoList() {
        List list = new ArrayList();
        ResourceLocation resourceLocation = WaystonesInteractPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-ID>(...)");
        list.add(new PacketRegisterInfo(resourceLocation, (Function1)new Function1<RegistryFriendlyByteBuf, WaystonesInteractPacket>((Object)WaystonesInteractPacket.Companion){

            public final WaystonesInteractPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((WaystonesInteractPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)WaystonesInteractHandler.INSTANCE, null, 8, null));
        return list;
    }
}

