/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.jade;

import com.arcaryx.cobblemonintegrations.util.MiscUtilsKt;
import com.cobblemon.mod.common.api.fossil.Fossil;
import com.cobblemon.mod.common.api.multiblock.MultiblockStructure;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.block.RestorationTankBlock;
import com.cobblemon.mod.common.block.entity.FossilMultiblockEntity;
import com.cobblemon.mod.common.block.multiblock.FossilMultiblockStructure;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/arcaryx/cobblemonintegrations/jade/FossilAnalyzerProvider;", "Lsnownee/jade/api/IBlockComponentProvider;", "Lsnownee/jade/api/IServerDataProvider;", "Lsnownee/jade/api/BlockAccessor;", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "getUid", "ORGANIC_MATERIAL_TAG", "", "appendServerData", "", "data", "Lnet/minecraft/nbt/CompoundTag;", "accessor", "appendTooltip", "tooltip", "Lsnownee/jade/api/ITooltip;", "config", "Lsnownee/jade/api/config/IPluginConfig;", "cobblemonintegrations-common-1.21.1"})
public final class FossilAnalyzerProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    @NotNull
    public static final FossilAnalyzerProvider INSTANCE = new FossilAnalyzerProvider();
    @NotNull
    private static final ResourceLocation ID;
    @NotNull
    private static final String ORGANIC_MATERIAL_TAG = "ci_organic_material";

    private FossilAnalyzerProvider() {
    }

    @NotNull
    public final ResourceLocation getID() {
        return ID;
    }

    @NotNull
    public ResourceLocation getUid() {
        return ID;
    }

    public void appendServerData(@NotNull CompoundTag data, @NotNull BlockAccessor accessor) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        BlockEntity blockEntity = accessor.getBlockEntity();
        FossilMultiblockEntity fossilMultiblockEntity = blockEntity instanceof FossilMultiblockEntity ? (FossilMultiblockEntity)blockEntity : null;
        if (fossilMultiblockEntity == null) {
            return;
        }
        FossilMultiblockEntity block = fossilMultiblockEntity;
        MultiblockStructure multiblockStructure = block.getMultiblockStructure();
        FossilMultiblockStructure fossilMultiblockStructure = multiblockStructure instanceof FossilMultiblockStructure ? (FossilMultiblockStructure)multiblockStructure : null;
        if (fossilMultiblockStructure == null) {
            return;
        }
        FossilMultiblockStructure multiBlock = fossilMultiblockStructure;
        data.putInt(ORGANIC_MATERIAL_TAG, multiBlock.getOrganicMaterialInside());
    }

    public void appendTooltip(@NotNull ITooltip tooltip, @NotNull BlockAccessor accessor, @NotNull IPluginConfig config) {
        BlockEntity blockEntity;
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        BlockEntity blockEntity2 = accessor.getBlockEntity();
        if (accessor.getBlock() instanceof RestorationTankBlock && accessor.getBlockState().getValue((Property)RestorationTankBlock.Companion.getPART()) == RestorationTankBlock.TankPart.TOP) {
            blockEntity2 = accessor.getLevel().getBlockEntity(accessor.getBlockEntity().getBlockPos().below());
        }
        FossilMultiblockEntity fossilMultiblockEntity = (blockEntity = blockEntity2) instanceof FossilMultiblockEntity ? (FossilMultiblockEntity)blockEntity : null;
        if (fossilMultiblockEntity == null) {
            return;
        }
        FossilMultiblockEntity block = fossilMultiblockEntity;
        Object[] objectArray = block.getMultiblockStructure();
        FossilMultiblockStructure fossilMultiblockStructure = objectArray instanceof FossilMultiblockStructure ? (FossilMultiblockStructure)objectArray : null;
        if (fossilMultiblockStructure == null) {
            FossilAnalyzerProvider $this$appendTooltip_u24lambda_u240 = this;
            boolean bl = false;
            tooltip.add((Component)Component.translatable((String)"cobblemonintegrations.jade.fossil_analyzer.incomplete"));
            return;
        }
        FossilMultiblockStructure multiBlock = fossilMultiblockStructure;
        if (multiBlock.getHasCreatedPokemon() && multiBlock.getResultingFossil() != null) {
            Fossil fossil = multiBlock.getResultingFossil();
            Intrinsics.checkNotNull((Object)fossil);
            MutableComponent resultComponent = TextKt.green((MutableComponent)Pokemon.getDisplayName$default((Pokemon)PokemonProperties.create$default((PokemonProperties)fossil.getResult(), null, (int)1, null), (boolean)false, (int)1, null));
            objectArray = new Object[]{resultComponent};
            tooltip.add((Component)Component.translatable((String)"cobblemonintegrations.jade.fossil_analyzer.completed", (Object[])objectArray));
            return;
        }
        IElementHelper helper = IElementHelper.get();
        if (multiBlock.isRunning()) {
            float current = multiBlock.getTimeRemaining();
            int max = 14400;
            float percentage = 1.0f - current / (float)max;
            ProgressStyle progressStyle = helper.progressStyle();
            Integer n = ChatFormatting.BLUE.getColor();
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = ChatFormatting.DARK_BLUE.getColor();
            Intrinsics.checkNotNull((Object)n3);
            ProgressStyle progressStyle2 = progressStyle.color(n2, n3.intValue());
            Object[] objectArray2 = new Object[]{MathKt.roundToInt((float)(percentage * (float)100))};
            MutableComponent mutableComponent = Component.translatable((String)"cobblemonintegrations.jade.fossil_analyzer.progress", (Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            MutableComponent component = TextKt.aqua((MutableComponent)mutableComponent);
            tooltip.add(helper.progress(percentage, (Component)component, progressStyle2, BoxStyle.getNestedBox(), true));
        } else {
            float currentMat = accessor.getServerData().contains(ORGANIC_MATERIAL_TAG) ? (float)accessor.getServerData().getInt(ORGANIC_MATERIAL_TAG) : (float)multiBlock.getOrganicMaterialInside();
            int maxMat = 128;
            float percentageMat = currentMat / (float)maxMat;
            ProgressStyle progressStyleMat = helper.progressStyle().color(102, 26972);
            Object[] objectArray3 = new Object[]{MathKt.roundToInt((float)(percentageMat * (float)100))};
            MutableComponent mutableComponent = Component.translatable((String)"cobblemonintegrations.jade.fossil_analyzer.organic_material", (Object[])objectArray3);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            MutableComponent componentMat = TextKt.green((MutableComponent)mutableComponent);
            tooltip.add(helper.progress(percentageMat, (Component)componentMat, progressStyleMat, BoxStyle.getNestedBox(), true));
        }
    }

    static {
        ResourceLocation resourceLocation = MiscUtilsKt.modResource("fossil_analyzer");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"modResource(...)");
        ID = resourceLocation;
    }
}

