/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.enhancedcelestials;

import com.arcaryx.cobblemonintegrations.enhancedcelestials.PokemonLunarEvent;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.corgitaco.enhancedcelestials.EnhancedCelestials;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import dev.corgitaco.enhancedcelestials.lunarevent.EnhancedCelestialsLunarForecastWorldData;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\u0011\u001a\u00020\u000b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0018"}, d2={"Lcom/arcaryx/cobblemonintegrations/enhancedcelestials/EnhancedCelestialsHandler;", "", "<init>", "()V", "isOngoingLunarEvent", "", "level", "Lnet/minecraft/world/level/Level;", "lunarEvent", "Lnet/minecraft/resources/ResourceLocation;", "modifySpawn", "", "pokemonEntity", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "modifyBattleExp", "", "baseExp", "modifyBattleEVs", "baseChanges", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "getLunarEventName", "Lnet/minecraft/network/chat/Component;", "eventLocation", "cobblemonintegrations-common-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEnhancedCelestialsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnhancedCelestialsHandler.kt\ncom/arcaryx/cobblemonintegrations/enhancedcelestials/EnhancedCelestialsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1869#2,2:94\n*S KotlinDebug\n*F\n+ 1 EnhancedCelestialsHandler.kt\ncom/arcaryx/cobblemonintegrations/enhancedcelestials/EnhancedCelestialsHandler\n*L\n43#1:94,2\n*E\n"})
public final class EnhancedCelestialsHandler {
    @NotNull
    public static final EnhancedCelestialsHandler INSTANCE = new EnhancedCelestialsHandler();

    private EnhancedCelestialsHandler() {
    }

    public final boolean isOngoingLunarEvent(@NotNull Level level, @NotNull ResourceLocation lunarEvent) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)lunarEvent, (String)"lunarEvent");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        return lunarForecastWorldData.isPresent() && ((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(lunarEvent);
    }

    public final void modifySpawn(@NotNull PokemonEntity pokemonEntity) {
        Intrinsics.checkNotNullParameter((Object)pokemonEntity, (String)"pokemonEntity");
        Level level = pokemonEntity.level();
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isPresent()) {
            Registry registry = level.registryAccess().registryOrThrow(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(event.getLunarEvent())) continue;
                if (Cobblemon.INSTANCE.getConfig().getShinyRate() >= 1.0f && event.getShinyMultiplier() > 0.0f) {
                    float modifiedShinyRate = Cobblemon.INSTANCE.getConfig().getShinyRate() / event.getShinyMultiplier();
                    if (Random.Default.nextFloat() < 1.0f / modifiedShinyRate) {
                        pokemonEntity.getPokemon().setShiny(true);
                    }
                }
                if (event.getPerfIVs() <= 0) break;
                IVs newIVs = IVs.Companion.createRandomIVs(event.getPerfIVs());
                Iterable $this$forEach$iv = Stats.Companion.getPERMANENT();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Stat stat = (Stat)element$iv;
                    boolean bl = false;
                    Pokemon pokemon = pokemonEntity.getPokemon();
                    Integer n = newIVs.get(stat);
                    Intrinsics.checkNotNull((Object)n);
                    pokemon.setIV(stat, n.intValue());
                }
            }
        }
    }

    public final int modifyBattleExp(int baseExp, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isPresent()) {
            Registry registry = level.registryAccess().registryOrThrow(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(event.getLunarEvent())) continue;
                return MathKt.roundToInt((float)((float)baseExp * event.getExpMultiplier()));
            }
        }
        return baseExp;
    }

    public final void modifyBattleEVs(@NotNull Map<Stat, Integer> baseChanges, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(baseChanges, (String)"baseChanges");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Optional lunarForecastWorldData = EnhancedCelestials.lunarForecastWorldData((Level)level);
        if (lunarForecastWorldData.isPresent()) {
            Registry registry = level.registryAccess().registryOrThrow(PokemonLunarEvent.Companion.getKEY());
            for (PokemonLunarEvent event : registry) {
                if (!((EnhancedCelestialsLunarForecastWorldData)lunarForecastWorldData.get()).currentLunarEventHolder().is(event.getLunarEvent())) continue;
                for (Stat stat : baseChanges.keySet()) {
                    Integer n = baseChanges.get(stat);
                    int base = n != null ? n : 0;
                    baseChanges.put(stat, MathKt.roundToInt((float)((float)Math.ceil((float)base * event.getEvMultiplier()))));
                }
            }
        }
    }

    @NotNull
    public final Component getLunarEventName(@NotNull ResourceLocation eventLocation, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)eventLocation, (String)"eventLocation");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Registry registry = level.registryAccess().registryOrThrow(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY);
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"registryOrThrow(...)");
        Registry lunarEventRegistry = registry;
        LunarEvent lunarEvent = (LunarEvent)lunarEventRegistry.get(eventLocation);
        if (lunarEvent != null) {
            Component component = lunarEvent.getTextComponents().name().getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getComponent(...)");
            return component;
        }
        MutableComponent mutableComponent = Component.literal((String)eventLocation.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }
}

