/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.client;

import com.arcaryx.cobblemonintegrations.CobblemonIntegrations;
import com.arcaryx.cobblemonintegrations.data.EvoItem;
import com.arcaryx.cobblemonintegrations.data.PokemonDrop;
import com.arcaryx.cobblemonintegrations.enhancedcelestials.LunarEventRequirement;
import com.arcaryx.cobblemonintegrations.sereneseasons.SereneSeasonRequirement;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.requirement.Requirement;
import com.cobblemon.mod.common.client.render.models.blockbench.FloatingState;
import com.cobblemon.mod.common.client.render.models.blockbench.PosableState;
import com.cobblemon.mod.common.client.render.models.blockbench.repository.VaryingModelRepository;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.evolution.variants.ItemInteractionEvolution;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/arcaryx/cobblemonintegrations/client/ClientCache;", "", "<init>", "()V", "dropsCache", "", "Lcom/arcaryx/cobblemonintegrations/data/PokemonDrop;", "getDropsCache", "()Ljava/util/List;", "setDropsCache", "(Ljava/util/List;)V", "evoItemsCache", "Lcom/arcaryx/cobblemonintegrations/data/EvoItem;", "getEvoItemsCache", "setEvoItemsCache", "filterDropsCache", "", "filterEvoItemsCache", "cobblemonintegrations-common-1.21.1"})
@SourceDebugExtension(value={"SMAP\nClientCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientCache.kt\ncom/arcaryx/cobblemonintegrations/client/ClientCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1761#2,3:78\n*S KotlinDebug\n*F\n+ 1 ClientCache.kt\ncom/arcaryx/cobblemonintegrations/client/ClientCache\n*L\n50#1:78,3\n*E\n"})
public final class ClientCache {
    @NotNull
    public static final ClientCache INSTANCE = new ClientCache();
    public static List<PokemonDrop> dropsCache;
    public static List<EvoItem> evoItemsCache;

    private ClientCache() {
    }

    @NotNull
    public final List<PokemonDrop> getDropsCache() {
        List<PokemonDrop> list = dropsCache;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dropsCache");
        return null;
    }

    public final void setDropsCache(@NotNull List<PokemonDrop> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        dropsCache = list;
    }

    @NotNull
    public final List<EvoItem> getEvoItemsCache() {
        List<EvoItem> list = evoItemsCache;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"evoItemsCache");
        return null;
    }

    public final void setEvoItemsCache(@NotNull List<EvoItem> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        evoItemsCache = list;
    }

    public final void filterDropsCache() {
        if (dropsCache != null) {
            this.getDropsCache().removeIf(arg_0 -> ClientCache.filterDropsCache$lambda$1(ClientCache::filterDropsCache$lambda$0, arg_0));
        }
    }

    public final void filterEvoItemsCache() {
        if (evoItemsCache != null) {
            this.getEvoItemsCache().removeIf(arg_0 -> ClientCache.filterEvoItemsCache$lambda$1(ClientCache::filterEvoItemsCache$lambda$0, arg_0));
        }
    }

    private static final boolean filterDropsCache$lambda$0(PokemonDrop pokemonDrop) {
        Intrinsics.checkNotNullParameter((Object)pokemonDrop, (String)"pokemonDrop");
        Species species = PokemonSpecies.getByIdentifier((ResourceLocation)pokemonDrop.getSpecies());
        if (species == null) {
            return true;
        }
        Species species2 = species;
        boolean implemented = species2.getImplemented();
        boolean isBaseForm = Intrinsics.areEqual((Object)pokemonDrop.getForm(), (Object)species2.getStandardForm().getName());
        FloatingState state = new FloatingState();
        state.setCurrentAspects(CollectionsKt.toSet((Iterable)species2.getStandardForm().getAspects()));
        ResourceLocation baseTexture = VaryingModelRepository.INSTANCE.getTexture(species2.getResourceIdentifier(), (PosableState)state);
        state.setCurrentAspects(CollectionsKt.toSet((Iterable)species2.getFormByName(pokemonDrop.getForm()).getAspects()));
        ResourceLocation formTexture = VaryingModelRepository.INSTANCE.getTexture(species2.getResourceIdentifier(), (PosableState)state);
        return !implemented || !isBaseForm && Intrinsics.areEqual((Object)baseTexture, (Object)formTexture);
    }

    private static final boolean filterDropsCache$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean filterEvoItemsCache$lambda$0(EvoItem evoItem) {
        boolean bl;
        ResourceLocation evoBaseTexture;
        ResourceLocation baseTexture;
        FloatingState state;
        Species evoSpecies;
        Species species;
        block7: {
            Intrinsics.checkNotNullParameter((Object)evoItem, (String)"evoItem");
            evoItem.fixJson();
            ItemInteractionEvolution itemInteractionEvolution = evoItem.getEvolution();
            Intrinsics.checkNotNull((Object)itemInteractionEvolution);
            PokemonProperties evo = itemInteractionEvolution.getResult();
            Species species2 = PokemonSpecies.getByIdentifier((ResourceLocation)evoItem.getSpecies());
            if (species2 == null) {
                return true;
            }
            species = species2;
            String string = evo.getSpecies();
            Intrinsics.checkNotNull((Object)string);
            Species species3 = PokemonSpecies.getByName((String)string);
            if (species3 == null) {
                return true;
            }
            evoSpecies = species3;
            state = new FloatingState();
            state.setCurrentAspects(CollectionsKt.toSet((Iterable)species.getStandardForm().getAspects()));
            baseTexture = VaryingModelRepository.INSTANCE.getTexture(species.getResourceIdentifier(), (PosableState)state);
            state.setCurrentAspects(CollectionsKt.toSet((Iterable)evoSpecies.getStandardForm().getAspects()));
            evoBaseTexture = VaryingModelRepository.INSTANCE.getTexture(evoSpecies.getResourceIdentifier(), (PosableState)state);
            DefaultedRegistry defaultedRegistry = BuiltInRegistries.ITEM;
            Intrinsics.checkNotNullExpressionValue((Object)defaultedRegistry, (String)"ITEM");
            Iterable $this$any$iv = (Iterable)defaultedRegistry;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Item item = (Item)element$iv;
                    boolean bl2 = false;
                    ItemStack itemStack = new ItemStack((ItemLike)item);
                    ItemInteractionEvolution itemInteractionEvolution2 = evoItem.getEvolution();
                    Intrinsics.checkNotNull((Object)itemInteractionEvolution2);
                    if (!itemInteractionEvolution2.getRequiredContext().test(itemStack)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasItems = bl;
        boolean implemented = species.getImplemented();
        boolean evoImplemented = evoSpecies.getImplemented();
        boolean isBaseForm = Intrinsics.areEqual(evoItem.getAspects(), (Object)CollectionsKt.toSet((Iterable)species.getStandardForm().getAspects()));
        boolean evoIsBaseForm = Intrinsics.areEqual(evoItem.getEvoAspects(), (Object)CollectionsKt.toSet((Iterable)evoSpecies.getStandardForm().getAspects()));
        state.setCurrentAspects(evoItem.getAspects());
        ResourceLocation formTexture = VaryingModelRepository.INSTANCE.getTexture(species.getResourceIdentifier(), (PosableState)state);
        state.setCurrentAspects(evoItem.getEvoAspects());
        ResourceLocation evoFormTexture = VaryingModelRepository.INSTANCE.getTexture(evoSpecies.getResourceIdentifier(), (PosableState)state);
        ItemInteractionEvolution itemInteractionEvolution = evoItem.getEvolution();
        Intrinsics.checkNotNull((Object)itemInteractionEvolution);
        for (Requirement rec : itemInteractionEvolution.getRequirements()) {
            if (rec instanceof LunarEventRequirement && !CobblemonIntegrations.INSTANCE.getPlatform().isModInstalled("enhancedcelestials")) {
                return true;
            }
            if (!(rec instanceof SereneSeasonRequirement) || CobblemonIntegrations.INSTANCE.getPlatform().isModInstalled("sereneseasons")) continue;
            return true;
        }
        return !implemented || !evoImplemented || !hasItems || !isBaseForm && Intrinsics.areEqual((Object)baseTexture, (Object)formTexture) || !evoIsBaseForm && Intrinsics.areEqual((Object)evoBaseTexture, (Object)evoFormTexture);
    }

    private static final boolean filterEvoItemsCache$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

