/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.core.entry.CompositeLootEntry;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.entry.SimpleLootEntry;
import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.loot.table.LootEntriesTransformer;
import com.almostreliable.lootjs.loot.table.LootEntryAppender;
import com.almostreliable.lootjs.util.DebugInfo;
import com.almostreliable.lootjs.util.ListHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;

public class LootEntryList
extends ListHolder<LootEntry, LootPoolEntryContainer>
implements LootEntriesTransformer,
LootEntryAppender {
    public LootEntryList() {
    }

    public LootEntryList(LootEntry ... entries) {
        super(new ArrayList(entries.length));
        for (LootEntry entry : entries) {
            this.add(entry);
        }
    }

    public LootEntryList(List<LootPoolEntryContainer> entries) {
        super(entries);
    }

    @Override
    public ListIterator<LootEntry> iterator() {
        return new ListIt(this.elements);
    }

    @Override
    protected LootEntry wrap(LootPoolEntryContainer entry) {
        return LootEntry.ofVanilla(entry);
    }

    @Override
    protected LootPoolEntryContainer unwrap(LootEntry entry) {
        return entry.getVanillaEntry();
    }

    public List<LootPoolEntryContainer> createVanillaArray() {
        ArrayList<LootPoolEntryContainer> entries = new ArrayList<LootPoolEntryContainer>(this.size());
        for (LootEntry e : this) {
            entries.add(e.getVanillaEntry());
        }
        return entries;
    }

    public void collectDebugInfo(DebugInfo info) {
        if (this.isEmpty()) {
            return;
        }
        info.add("% Entries: [");
        info.push();
        info.add("{");
        info.push();
        for (LootEntry entry : this) {
            entry.collectDebugInfo(info);
        }
        info.pop();
        info.add("}");
        info.pop();
        info.add("]");
    }

    public void modify(UnaryOperator<LootEntry> onTransform) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            try {
                LootEntry entry = (LootEntry)it.next();
                LootEntry transformed = (LootEntry)onTransform.apply(entry);
                if (transformed == entry) continue;
                it.set(transformed);
            }
            catch (Exception e) {
                LootJS.LOG.error("Failed to transform entry", (Throwable)e);
            }
        }
    }

    @Override
    public LootEntryList modifyEntry(UnaryOperator<SimpleLootEntry> onTransform, boolean deepTransform) {
        this.modify(entry -> {
            if (entry instanceof LootEntriesTransformer) {
                LootEntriesTransformer helper = (LootEntriesTransformer)((Object)entry);
                if (deepTransform) {
                    helper.modifyEntry(onTransform, true);
                    return entry;
                }
            }
            if (entry instanceof SimpleLootEntry) {
                SimpleLootEntry le = (SimpleLootEntry)entry;
                return (LootEntry)onTransform.apply(le);
            }
            return entry;
        });
        return this;
    }

    @Override
    public LootEntryList removeEntry(Predicate<SimpleLootEntry> filter, boolean deepRemove) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            SimpleLootEntry le;
            LootEntry entry = (LootEntry)it.next();
            if (entry instanceof CompositeLootEntry) {
                CompositeLootEntry composite = (CompositeLootEntry)entry;
                if (deepRemove) {
                    composite.removeEntry((Predicate)filter, true);
                    continue;
                }
            }
            if (!(entry instanceof SimpleLootEntry) || !filter.test(le = (SimpleLootEntry)entry)) continue;
            it.remove();
        }
        return this;
    }

    @Override
    public LootEntryList addEntry(LootEntry entry) {
        this.add(entry);
        return this;
    }

    public boolean remove(IdFilter type) {
        return this.elements.removeIf(element -> type.test(BuiltInRegistries.LOOT_POOL_ENTRY_TYPE.getKey((Object)element.getType())));
    }

    public boolean contains(LootPoolEntryType type) {
        return this.indexOf(type) != -1;
    }

    public int indexOf(LootPoolEntryType type) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((LootPoolEntryContainer)this.elements.get(i)).getType().equals((Object)type)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(LootPoolEntryType type) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            if (!((LootPoolEntryContainer)this.elements.get(i)).getType().equals((Object)type)) continue;
            return i;
        }
        return -1;
    }

    private static class ListIt
    implements ListIterator<LootEntry> {
        private final ListIterator<LootPoolEntryContainer> it;

        public ListIt(List<LootPoolEntryContainer> entries) {
            this.it = entries.listIterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public LootEntry next() {
            return LootEntry.ofVanilla(this.it.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasPrevious();
        }

        @Override
        public LootEntry previous() {
            return LootEntry.ofVanilla(this.it.previous());
        }

        @Override
        public int nextIndex() {
            return this.it.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.previousIndex();
        }

        @Override
        public void remove() {
            this.it.remove();
        }

        @Override
        public void set(LootEntry lootEntry) {
            this.it.set(lootEntry.getVanillaEntry());
        }

        @Override
        public void add(LootEntry lootEntry) {
            this.it.add(lootEntry.getVanillaEntry());
        }
    }
}

