/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.core.entry.ItemLootEntry;
import com.almostreliable.lootjs.core.entry.LootEntry;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import com.almostreliable.lootjs.loot.modifier.GroupedLootAction;
import com.almostreliable.lootjs.loot.modifier.LootAction;
import com.almostreliable.lootjs.loot.modifier.handler.AddLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.CustomPlayerAction;
import com.almostreliable.lootjs.loot.modifier.handler.DropExperienceAction;
import com.almostreliable.lootjs.loot.modifier.handler.ExplodeAction;
import com.almostreliable.lootjs.loot.modifier.handler.LightningStrikeAction;
import com.almostreliable.lootjs.loot.modifier.handler.LootPoolAction;
import com.almostreliable.lootjs.loot.modifier.handler.ModifyLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.RemoveLootAction;
import com.almostreliable.lootjs.loot.modifier.handler.ReplaceLootAction;
import com.almostreliable.lootjs.loot.table.MutableLootPool;
import java.util.function.Consumer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootActionContainer<A extends LootActionContainer<?>> {
    default public A addLoot(LootEntry ... entries) {
        return this.addAction(new AddLootAction(entries));
    }

    default public A addAlternativesLoot(LootEntry ... entries) {
        return this.addAction(new AddLootAction(LootEntry.alternative(entries)));
    }

    default public A addSequenceLoot(LootEntry ... entries) {
        return this.addAction(new AddLootAction(LootEntry.sequence(entries)));
    }

    default public A removeLoot(ItemFilter filter) {
        return this.addAction(new RemoveLootAction(filter));
    }

    default public A replaceLoot(ItemFilter filter, ItemLootEntry itemLootEntry) {
        return this.replaceLoot(filter, itemLootEntry, false);
    }

    default public A replaceLoot(ItemFilter filter, ItemLootEntry itemLootEntry, boolean preserveCount) {
        return this.replaceLoot(filter, itemLootEntry, preserveCount, new DataComponentType[0]);
    }

    default public A replaceLoot(ItemFilter filter, ItemLootEntry itemLootEntry, boolean preserveCount, DataComponentType<?>[] preserveComponentTypes) {
        return this.addAction(new ReplaceLootAction(filter, itemLootEntry, preserveCount, preserveComponentTypes));
    }

    default public A modifyLoot(ItemFilter filter, ModifyLootAction.Callback callback) {
        return this.addAction(new ModifyLootAction(filter, callback));
    }

    default public A triggerExplosion(float radius, boolean destroy, boolean fire) {
        Explosion.BlockInteraction mode = destroy ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
        return this.addAction(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerExplosion(float radius, Explosion.BlockInteraction mode, boolean fire) {
        return this.addAction(new ExplodeAction(radius, mode, fire));
    }

    default public A triggerLightningStrike(boolean shouldDamage) {
        return this.addAction(new LightningStrikeAction(shouldDamage));
    }

    default public A dropExperience(NumberProvider amount) {
        return this.addAction(new DropExperienceAction(amount));
    }

    default public A customAction(LootAction action) {
        return this.addAction(action);
    }

    default public A playerAction(Consumer<ServerPlayer> action) {
        return this.addAction(new CustomPlayerAction(action));
    }

    default public A group(ItemFilter filter, Consumer<GroupedLootAction.Builder> onCreateGroup) {
        GroupedLootAction.Builder builder = new GroupedLootAction.Builder(filter);
        onCreateGroup.accept(builder);
        return this.addAction(builder.build());
    }

    default public A group(Consumer<GroupedLootAction.Builder> onCreateGroup) {
        GroupedLootAction.Builder builder = new GroupedLootAction.Builder();
        onCreateGroup.accept(builder);
        return this.addAction(builder.build());
    }

    default public A pool(Consumer<MutableLootPool> onCreatePool) {
        MutableLootPool pool = new MutableLootPool(LootPool.lootPool().build());
        onCreatePool.accept(pool);
        return this.addAction(new LootPoolAction(pool.getVanillaPool()));
    }

    public A addAction(LootAction var1);
}

