/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.filters;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public interface IdFilter
extends Predicate<ResourceLocation> {

    public record Or(List<IdFilter> filters) implements IdFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.filters.stream().anyMatch(filter -> filter.test(resourceLocation));
        }

        @Override
        public String toString() {
            return "Or[" + StringUtils.join(this.filters, (String)", ") + "]";
        }
    }

    public record ByMod(String mod) implements IdFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return resourceLocation.getNamespace().equals(this.mod);
        }

        @Override
        public String toString() {
            return "Mod[" + this.mod + "]";
        }
    }

    public record ByPattern(Pattern pattern) implements IdFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.pattern.matcher(resourceLocation.toString()).matches();
        }

        @Override
        public String toString() {
            return "Pattern[" + this.pattern.pattern() + "]";
        }
    }

    public record ByLocation(ResourceLocation location) implements IdFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.location.equals((Object)resourceLocation);
        }

        @Override
        public String toString() {
            return "Id[" + String.valueOf(this.location) + "]";
        }
    }
}

