/*
 * Decompiled with CFR 0.152.
 */
package dev.stick_stack.dimensionviewer.platform;

import dev.stick_stack.dimensionviewer.CommonUtils;
import dev.stick_stack.dimensionviewer.ConfigCommon;
import dev.stick_stack.dimensionviewer.ConfigNeoForge;
import dev.stick_stack.dimensionviewer.platform.services.IConfigHelper;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class NeoForgeConfigHelper
implements IConfigHelper {
    @Override
    public String BaseDefaultColor() {
        return ConfigCommon.DEFAULT_COLOR;
    }

    @Override
    public String BaseOverworldColor() {
        return ConfigCommon.OVERWORLD_COLOR;
    }

    @Override
    public String BaseNetherColor() {
        return ConfigCommon.NETHER_COLOR;
    }

    @Override
    public String BaseEndColor() {
        return ConfigCommon.END_COLOR;
    }

    @Override
    public String BaseListFormat() {
        return ConfigCommon.DEFAULT_LIST_FORMAT;
    }

    @Override
    public String DefaultColor() {
        return ConfigCommon.DEFAULT_COLOR;
    }

    @Override
    public String OverworldColor() {
        return (String)ConfigNeoForge.OVERWORLD_COLOR.get();
    }

    @Override
    public String NetherColor() {
        return (String)ConfigNeoForge.NETHER_COLOR.get();
    }

    @Override
    public String EndColor() {
        return (String)ConfigNeoForge.END_COLOR.get();
    }

    @Override
    public String ListFormat() {
        return (String)ConfigNeoForge.LIST_FORMAT.get();
    }

    @Override
    public List<String> GetAllCustomColors() {
        return (List)ConfigNeoForge.CUSTOM_COLORS.get();
    }

    @Override
    public void AddCustomColor(String name, String color) {
        List colors = (List)ConfigNeoForge.CUSTOM_COLORS.get();
        colors.add("%s %s".formatted(name, color));
        ConfigNeoForge.CUSTOM_COLORS.set((Object)colors);
        ConfigNeoForge.CUSTOM_COLORS.save();
    }

    @Override
    public boolean RemoveCustomColor(String name) {
        List colors = (List)ConfigNeoForge.CUSTOM_COLORS.get();
        int i = 0;
        for (String c : colors) {
            if (c.split(" ")[0].equals(name)) {
                colors.remove(i);
                ConfigNeoForge.CUSTOM_COLORS.set((Object)colors);
                ConfigNeoForge.CUSTOM_COLORS.save();
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    @Nullable
    public String GetAlias(String dimId) {
        for (String dim : (List)ConfigNeoForge.DIM_ALIASES.get()) {
            String[] values = dim.split(" ", 2);
            if (!dimId.equals(values[0])) continue;
            return values[1];
        }
        return null;
    }

    @Override
    @Nullable
    public String GetCustomColor(String dimId) {
        return switch (dimId) {
            case "minecraft:overworld" -> this.OverworldColor();
            case "minecraft:the_nether" -> this.NetherColor();
            case "minecraft:the_end" -> this.EndColor();
            default -> {
                for (String dim : (List)ConfigNeoForge.MODDED_DIMS.get()) {
                    String[] values = dim.split(" ", 2);
                    if (!dimId.equals(values[0])) continue;
                    yield values[1];
                }
                yield null;
            }
        };
    }

    @Override
    public void SetAlias(String dimId, String alias) {
        List aliases = (List)ConfigNeoForge.DIM_ALIASES.get();
        int i = 0;
        for (String dim : aliases) {
            String[] values = dim.split(" ", 2);
            if (dimId.equals(values[0])) {
                aliases.set(i, "%s %s".formatted(dimId, alias));
                ConfigNeoForge.DIM_ALIASES.set((Object)aliases);
                ConfigNeoForge.DIM_ALIASES.save();
                return;
            }
            ++i;
        }
        aliases.add(i, "%s %s".formatted(dimId, alias));
        ConfigNeoForge.DIM_ALIASES.set((Object)aliases);
        ConfigNeoForge.DIM_ALIASES.save();
    }

    @Override
    public void SetColor(String dimId, String color) {
        List dims = (List)ConfigNeoForge.MODDED_DIMS.get();
        switch (dimId) {
            case "minecraft:overworld": {
                ConfigNeoForge.OVERWORLD_COLOR.set((Object)color);
                ConfigNeoForge.OVERWORLD_COLOR.save();
                break;
            }
            case "minecraft:the_nether": {
                ConfigNeoForge.NETHER_COLOR.set((Object)color);
                ConfigNeoForge.NETHER_COLOR.save();
                break;
            }
            case "minecraft:the_end": {
                ConfigNeoForge.END_COLOR.set((Object)color);
                ConfigNeoForge.END_COLOR.save();
                break;
            }
            default: {
                int i = 0;
                for (String dim : (List)ConfigNeoForge.MODDED_DIMS.get()) {
                    String[] values = dim.split(" ", 2);
                    if (dimId.equals(values[0])) {
                        dims.set(i, "%s %s".formatted(dimId, color));
                        ConfigNeoForge.MODDED_DIMS.set((Object)dims);
                        ConfigNeoForge.MODDED_DIMS.save();
                        return;
                    }
                    ++i;
                }
                dims.add("%s %s".formatted(dimId, color));
                ConfigNeoForge.MODDED_DIMS.set((Object)dims);
                ConfigNeoForge.MODDED_DIMS.save();
            }
        }
    }

    @Override
    public void SetBoolSetting(String setting, boolean value) {
        switch (setting) {
            case "perDimColor": {
                ConfigNeoForge.PER_DIM_COLOR.set((Object)value);
                ConfigNeoForge.PER_DIM_COLOR.save();
                break;
            }
            case "dimInChatName": {
                ConfigNeoForge.DIM_IN_CHAT_NAME.set((Object)value);
                ConfigNeoForge.DIM_IN_CHAT_NAME.save();
                break;
            }
            case "chatDimHover": {
                ConfigNeoForge.CHAT_DIM_HOVER.set((Object)value);
                ConfigNeoForge.CHAT_DIM_HOVER.save();
                break;
            }
            case "enableAliases": {
                ConfigNeoForge.ENABLE_ALIASES.set((Object)value);
                ConfigNeoForge.ENABLE_ALIASES.save();
            }
        }
    }

    @Override
    public void ResetAlias(String dimId) {
        List aliases = (List)ConfigNeoForge.DIM_ALIASES.get();
        aliases.removeIf(a -> dimId.equals(a.split(" ", 2)[0]));
        ConfigNeoForge.DIM_ALIASES.set((Object)aliases);
        ConfigNeoForge.DIM_ALIASES.save();
    }

    @Override
    public void ResetColor(String dimId) {
        switch (dimId) {
            case "minecraft:overworld": {
                ConfigNeoForge.OVERWORLD_COLOR.set((Object)this.BaseOverworldColor());
                break;
            }
            case "minecraft:the_nether": {
                ConfigNeoForge.NETHER_COLOR.set((Object)this.BaseNetherColor());
                break;
            }
            case "minecraft:the_end": {
                ConfigNeoForge.END_COLOR.set((Object)this.BaseEndColor());
                break;
            }
            default: {
                List dims = (List)ConfigNeoForge.MODDED_DIMS.get();
                dims.removeIf(a -> dimId.equals(a.split(" ", 2)[0]));
                ConfigNeoForge.MODDED_DIMS.set((Object)dims);
                ConfigNeoForge.MODDED_DIMS.save();
            }
        }
    }

    @Override
    public void SetFormat(String format) {
        ConfigNeoForge.LIST_FORMAT.set((Object)format);
        ConfigNeoForge.LIST_FORMAT.save();
    }

    @Override
    public void SetPlacement(CommonUtils.DimensionPosition position) {
        ConfigNeoForge.DIM_POSITION.set((Object)position);
        ConfigNeoForge.DIM_POSITION.save();
    }

    @Override
    public void RefreshPlayerData(PlayerList players) {
        players.getPlayers().forEach(Player::refreshDisplayName);
        players.getPlayers().forEach(ServerPlayer::refreshTabListName);
    }

    @Override
    public boolean HasAlias(String dimId) {
        for (String dim : (List)ConfigNeoForge.DIM_ALIASES.get()) {
            if (!dim.split(" ", 2)[0].equals(dimId)) continue;
            return true;
        }
        return false;
    }
}

